/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class RequestHeaderData
implements ApiMessage {
    short requestApiKey;
    short requestApiVersion;
    int correlationId;
    String clientId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("request_api_key", Type.INT16, "The API key of this request."), new Field("request_api_version", Type.INT16, "The API version of this request."), new Field("correlation_id", Type.INT32, "The correlation ID of this request."));
    public static final Schema SCHEMA_1 = new Schema(new Field("request_api_key", Type.INT16, "The API key of this request."), new Field("request_api_version", Type.INT16, "The API version of this request."), new Field("correlation_id", Type.INT32, "The correlation ID of this request."), new Field("client_id", Type.NULLABLE_STRING, "The client ID string."));
    public static final Schema SCHEMA_2 = new Schema(new Field("request_api_key", Type.INT16, "The API key of this request."), new Field("request_api_version", Type.INT16, "The API version of this request."), new Field("correlation_id", Type.INT32, "The correlation ID of this request."), new Field("client_id", Type.NULLABLE_STRING, "The client ID string."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public RequestHeaderData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public RequestHeaderData() {
        this.requestApiKey = 0;
        this.requestApiVersion = 0;
        this.correlationId = 0;
        this.clientId = "";
    }

    @Override
    public short apiKey() {
        return -1;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.requestApiKey = _readable.readShort();
        this.requestApiVersion = _readable.readShort();
        this.correlationId = _readable.readInt();
        if (_version >= 1) {
            short length = _readable.readShort();
            if (length < 0) {
                this.clientId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field clientId had invalid length " + length);
                }
                this.clientId = _readable.readString(length);
            }
        } else {
            this.clientId = "";
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.requestApiKey);
        _writable.writeShort(this.requestApiVersion);
        _writable.writeInt(this.correlationId);
        if (_version >= 1) {
            if (this.clientId == null) {
                _writable.writeShort((short)-1);
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.clientId);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(2);
        _size.addBytes(2);
        _size.addBytes(4);
        if (_version >= 1) {
            if (this.clientId == null) {
                _size.addBytes(2);
            } else {
                byte[] _stringBytes = this.clientId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'clientId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.clientId, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RequestHeaderData)) {
            return false;
        }
        RequestHeaderData other = (RequestHeaderData)obj;
        if (this.requestApiKey != other.requestApiKey) {
            return false;
        }
        if (this.requestApiVersion != other.requestApiVersion) {
            return false;
        }
        if (this.correlationId != other.correlationId) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.requestApiKey;
        hashCode = 31 * hashCode + this.requestApiVersion;
        hashCode = 31 * hashCode + this.correlationId;
        hashCode = 31 * hashCode + (this.clientId == null ? 0 : this.clientId.hashCode());
        return hashCode;
    }

    @Override
    public RequestHeaderData duplicate() {
        RequestHeaderData _duplicate = new RequestHeaderData();
        _duplicate.requestApiKey = this.requestApiKey;
        _duplicate.requestApiVersion = this.requestApiVersion;
        _duplicate.correlationId = this.correlationId;
        _duplicate.clientId = this.clientId == null ? null : this.clientId;
        return _duplicate;
    }

    public String toString() {
        return "RequestHeaderData(requestApiKey=" + this.requestApiKey + ", requestApiVersion=" + this.requestApiVersion + ", correlationId=" + this.correlationId + ", clientId=" + (this.clientId == null ? "null" : "'" + this.clientId.toString() + "'") + ")";
    }

    public short requestApiKey() {
        return this.requestApiKey;
    }

    public short requestApiVersion() {
        return this.requestApiVersion;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public String clientId() {
        return this.clientId;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RequestHeaderData setRequestApiKey(short v) {
        this.requestApiKey = v;
        return this;
    }

    public RequestHeaderData setRequestApiVersion(short v) {
        this.requestApiVersion = v;
        return this;
    }

    public RequestHeaderData setCorrelationId(int v) {
        this.correlationId = v;
        return this;
    }

    public RequestHeaderData setClientId(String v) {
        this.clientId = v;
        return this;
    }
}

