/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.ByteBufferSend;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.Send;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Message;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.BaseRecords;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.MemoryRecords;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.MultiRecordsSend;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.UnalignedMemoryRecords;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.RequestHeader;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ResponseHeader;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class SendBuilder
implements Writable {
    private final ByteBuffer buffer;
    private final Queue<Send> sends = new ArrayDeque<Send>(1);
    private long sizeOfSends = 0L;
    private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private long sizeOfBuffers = 0L;

    SendBuilder(int size) {
        this.buffer = ByteBuffer.allocate(size);
        this.buffer.mark();
    }

    @Override
    public void writeByte(byte val) {
        this.buffer.put(val);
    }

    @Override
    public void writeShort(short val) {
        this.buffer.putShort(val);
    }

    @Override
    public void writeInt(int val) {
        this.buffer.putInt(val);
    }

    @Override
    public void writeLong(long val) {
        this.buffer.putLong(val);
    }

    @Override
    public void writeDouble(double val) {
        this.buffer.putDouble(val);
    }

    @Override
    public void writeByteArray(byte[] arr) {
        this.buffer.put(arr);
    }

    @Override
    public void writeUnsignedVarint(int i) {
        ByteUtils.writeUnsignedVarint(i, this.buffer);
    }

    @Override
    public void writeByteBuffer(ByteBuffer buf) {
        this.flushPendingBuffer();
        this.addBuffer(buf.duplicate());
    }

    @Override
    public void writeVarint(int i) {
        ByteUtils.writeVarint(i, this.buffer);
    }

    @Override
    public void writeVarlong(long i) {
        ByteUtils.writeVarlong(i, this.buffer);
    }

    private void addBuffer(ByteBuffer buffer) {
        this.buffers.add(buffer);
        this.sizeOfBuffers += (long)buffer.remaining();
    }

    private void addSend(Send send) {
        this.sends.add(send);
        this.sizeOfSends += send.size();
    }

    private void clearBuffers() {
        this.buffers.clear();
        this.sizeOfBuffers = 0L;
    }

    @Override
    public void writeRecords(BaseRecords records) {
        if (records instanceof MemoryRecords) {
            this.flushPendingBuffer();
            this.addBuffer(((MemoryRecords)records).buffer());
        } else if (records instanceof UnalignedMemoryRecords) {
            this.flushPendingBuffer();
            this.addBuffer(((UnalignedMemoryRecords)records).buffer());
        } else {
            this.flushPendingSend();
            this.addSend(records.toSend());
        }
    }

    private void flushPendingSend() {
        this.flushPendingBuffer();
        if (!this.buffers.isEmpty()) {
            ByteBuffer[] byteBufferArray = this.buffers.toArray(new ByteBuffer[0]);
            this.addSend(new ByteBufferSend(byteBufferArray, this.sizeOfBuffers));
            this.clearBuffers();
        }
    }

    private void flushPendingBuffer() {
        int latestPosition = this.buffer.position();
        this.buffer.reset();
        if (latestPosition > this.buffer.position()) {
            this.buffer.limit(latestPosition);
            this.addBuffer(this.buffer.slice());
            this.buffer.position(latestPosition);
            this.buffer.limit(this.buffer.capacity());
            this.buffer.mark();
        }
    }

    public Send build() {
        this.flushPendingSend();
        if (this.sends.size() == 1) {
            return this.sends.poll();
        }
        return new MultiRecordsSend(this.sends, this.sizeOfSends);
    }

    public static Send buildRequestSend(RequestHeader header, Message apiRequest) {
        return SendBuilder.buildSend(header.data(), header.headerVersion(), apiRequest, header.apiVersion());
    }

    public static Send buildResponseSend(ResponseHeader header, Message apiResponse, short apiVersion) {
        return SendBuilder.buildSend(header.data(), header.headerVersion(), apiResponse, apiVersion);
    }

    private static Send buildSend(Message header, short headerVersion, Message apiMessage, short apiVersion) {
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        MessageSizeAccumulator messageSize = new MessageSizeAccumulator();
        header.addSize(messageSize, serializationCache, headerVersion);
        apiMessage.addSize(messageSize, serializationCache, apiVersion);
        SendBuilder builder = new SendBuilder(messageSize.sizeExcludingZeroCopy() + 4);
        builder.writeInt(messageSize.totalSize());
        header.write(builder, serializationCache, headerVersion);
        apiMessage.write(builder, serializationCache, apiVersion);
        return builder.build();
    }
}

