/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.LeaderChangeMessage;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.ControlRecordType;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.Record;
import java.nio.ByteBuffer;

public class ControlRecordUtils {
    public static final short LEADER_CHANGE_SCHEMA_VERSION = new LeaderChangeMessage().highestSupportedVersion();

    public static LeaderChangeMessage deserializeLeaderChangeMessage(Record record) {
        ControlRecordType recordType = ControlRecordType.parse(record.key());
        if (recordType != ControlRecordType.LEADER_CHANGE) {
            throw new IllegalArgumentException("Expected LEADER_CHANGE control record type(3), but found " + recordType.toString());
        }
        return ControlRecordUtils.deserializeLeaderChangeMessage(record.value().duplicate());
    }

    public static LeaderChangeMessage deserializeLeaderChangeMessage(ByteBuffer data) {
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(data.duplicate());
        return new LeaderChangeMessage(byteBufferAccessor, LEADER_CHANGE_SCHEMA_VERSION);
    }
}

