/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.TopicPartition;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.BaseRecords;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.ConvertedRecords;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.LazyDownConversionRecordsSend;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.MemoryRecords;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.RecordBatch;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.Records;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.RecordsUtil;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.AbstractIterator;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.Time;
import java.util.ArrayList;
import java.util.Objects;

public class LazyDownConversionRecords
implements BaseRecords {
    private final TopicPartition topicPartition;
    private final Records records;
    private final byte toMagic;
    private final long firstOffset;
    private ConvertedRecords firstConvertedBatch;
    private final int sizeInBytes;
    private final Time time;

    public LazyDownConversionRecords(TopicPartition topicPartition, Records records, byte toMagic, long firstOffset, Time time) {
        this.topicPartition = Objects.requireNonNull(topicPartition);
        this.records = Objects.requireNonNull(records);
        this.toMagic = toMagic;
        this.firstOffset = firstOffset;
        this.time = Objects.requireNonNull(time);
        java.util.Iterator<ConvertedRecords<?>> it = this.iterator(0L);
        if (it.hasNext()) {
            this.firstConvertedBatch = it.next();
            this.sizeInBytes = Math.max(records.sizeInBytes(), this.firstConvertedBatch.records().sizeInBytes());
        } else {
            this.firstConvertedBatch = null;
            this.sizeInBytes = 12;
        }
    }

    @Override
    public int sizeInBytes() {
        return this.sizeInBytes;
    }

    public LazyDownConversionRecordsSend toSend() {
        return new LazyDownConversionRecordsSend(this);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public boolean equals(Object o) {
        if (o instanceof LazyDownConversionRecords) {
            LazyDownConversionRecords that = (LazyDownConversionRecords)o;
            return this.toMagic == that.toMagic && this.firstOffset == that.firstOffset && this.topicPartition.equals(that.topicPartition) && this.records.equals(that.records);
        }
        return false;
    }

    public int hashCode() {
        int result = this.toMagic;
        result = 31 * result + Long.hashCode(this.firstOffset);
        result = 31 * result + this.topicPartition.hashCode();
        result = 31 * result + this.records.hashCode();
        return result;
    }

    public String toString() {
        return "LazyDownConversionRecords(size=" + this.sizeInBytes + ", underlying=" + this.records + ", toMagic=" + this.toMagic + ", firstOffset=" + this.firstOffset + ")";
    }

    public java.util.Iterator<ConvertedRecords<?>> iterator(long maximumReadSize) {
        ConvertedRecords firstBatch = this.firstConvertedBatch;
        this.firstConvertedBatch = null;
        return new Iterator(this.records, maximumReadSize, firstBatch);
    }

    private class Iterator
    extends AbstractIterator<ConvertedRecords<?>> {
        private final AbstractIterator<? extends RecordBatch> batchIterator;
        private final long maximumReadSize;
        private ConvertedRecords firstConvertedBatch;

        private Iterator(Records recordsToDownConvert, long maximumReadSize, ConvertedRecords<?> firstConvertedBatch) {
            this.batchIterator = recordsToDownConvert.batchIterator();
            this.maximumReadSize = maximumReadSize;
            this.firstConvertedBatch = firstConvertedBatch;
            if (firstConvertedBatch != null) {
                this.batchIterator.next();
            }
        }

        @Override
        protected ConvertedRecords makeNext() {
            if (this.firstConvertedBatch != null) {
                ConvertedRecords convertedBatch = this.firstConvertedBatch;
                this.firstConvertedBatch = null;
                return convertedBatch;
            }
            while (this.batchIterator.hasNext()) {
                ArrayList<RecordBatch> batches = new ArrayList<RecordBatch>();
                boolean isFirstBatch = true;
                long sizeSoFar = 0L;
                while (this.batchIterator.hasNext() && (isFirstBatch || (long)this.batchIterator.peek().sizeInBytes() + sizeSoFar <= this.maximumReadSize)) {
                    RecordBatch currentBatch = this.batchIterator.next();
                    batches.add(currentBatch);
                    sizeSoFar += (long)currentBatch.sizeInBytes();
                    isFirstBatch = false;
                }
                ConvertedRecords<MemoryRecords> convertedRecords = RecordsUtil.downConvert(batches, LazyDownConversionRecords.this.toMagic, LazyDownConversionRecords.this.firstOffset, LazyDownConversionRecords.this.time);
                if (convertedRecords.records().sizeInBytes() <= 0) continue;
                return convertedRecords;
            }
            return (ConvertedRecords)this.allDone();
        }
    }
}

