/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.replica;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.Node;
import java.util.Comparator;
import java.util.Objects;

public interface ReplicaView {
    public Node endpoint();

    public long logEndOffset();

    public long timeSinceLastCaughtUpMs();

    public static Comparator<ReplicaView> comparator() {
        return Comparator.comparingLong(ReplicaView::logEndOffset).thenComparing(Comparator.comparingLong(ReplicaView::timeSinceLastCaughtUpMs).reversed()).thenComparing(replicaInfo -> replicaInfo.endpoint().id());
    }

    public static class DefaultReplicaView
    implements ReplicaView {
        private final Node endpoint;
        private final long logEndOffset;
        private final long timeSinceLastCaughtUpMs;

        public DefaultReplicaView(Node endpoint, long logEndOffset, long timeSinceLastCaughtUpMs) {
            this.endpoint = endpoint;
            this.logEndOffset = logEndOffset;
            this.timeSinceLastCaughtUpMs = timeSinceLastCaughtUpMs;
        }

        @Override
        public Node endpoint() {
            return this.endpoint;
        }

        @Override
        public long logEndOffset() {
            return this.logEndOffset;
        }

        @Override
        public long timeSinceLastCaughtUpMs() {
            return this.timeSinceLastCaughtUpMs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultReplicaView that = (DefaultReplicaView)o;
            return this.logEndOffset == that.logEndOffset && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.timeSinceLastCaughtUpMs, that.timeSinceLastCaughtUpMs);
        }

        public int hashCode() {
            return Objects.hash(this.endpoint, this.logEndOffset, this.timeSinceLastCaughtUpMs);
        }

        public String toString() {
            return "DefaultReplicaView{endpoint=" + this.endpoint + ", logEndOffset=" + this.logEndOffset + ", timeSinceLastCaughtUpMs=" + this.timeSinceLastCaughtUpMs + '}';
        }
    }
}

