/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.network.Send;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.SendBuilder;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractRequestResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AlterClientQuotasRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AlterConfigsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AlterIsrRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ApiVersionsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.BrokerRegistrationRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ControlledShutdownRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.CreateAclsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.CreateDelegationTokenRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.CreatePartitionsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.CreateTopicsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DeleteAclsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DeleteGroupsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DeleteRecordsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DeleteTopicsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeAclsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeClusterRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeConfigsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeDelegationTokenRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeGroupsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeLogDirsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeProducersRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeQuorumRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ElectLeadersRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.EndQuorumEpochRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.EndTxnRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.EnvelopeRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ExpireDelegationTokenRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.FetchRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.FetchSnapshotRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.FindCoordinatorRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.HeartbeatRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.InitProducerIdRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.JoinGroupRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.LeaderAndIsrRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.LeaveGroupRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ListGroupsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ListOffsetsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.MetadataRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.OffsetCommitRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.OffsetDeleteRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.OffsetFetchRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ProduceRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.RenewDelegationTokenRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.RequestAndSize;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.RequestHeader;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.SaslAuthenticateRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.SaslHandshakeRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.StopReplicaRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.SyncGroupRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.UnregisterBrokerRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.UpdateFeaturesRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.UpdateMetadataRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.VoteRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import java.nio.ByteBuffer;
import java.util.Map;

public abstract class AbstractRequest
implements AbstractRequestResponse {
    private final short version;
    private final ApiKeys apiKey;

    public AbstractRequest(ApiKeys apiKey, short version) {
        if (!apiKey.isVersionSupported(version)) {
            throw new UnsupportedVersionException("The " + (Object)((Object)apiKey) + " protocol does not support version " + version);
        }
        this.version = version;
        this.apiKey = apiKey;
    }

    public short version() {
        return this.version;
    }

    public ApiKeys apiKey() {
        return this.apiKey;
    }

    public final Send toSend(RequestHeader header) {
        return SendBuilder.buildRequestSend(header, this.data());
    }

    public final ByteBuffer serialize() {
        return MessageUtil.toByteBuffer(this.data(), this.version);
    }

    final int sizeInBytes() {
        return this.data().size(new ObjectSerializationCache(), this.version);
    }

    public String toString(boolean verbose) {
        return this.data().toString();
    }

    public final String toString() {
        return this.toString(true);
    }

    public AbstractResponse getErrorResponse(Throwable e) {
        return this.getErrorResponse(0, e);
    }

    public abstract AbstractResponse getErrorResponse(int var1, Throwable var2);

    public Map<Errors, Integer> errorCounts(Throwable e) {
        AbstractResponse response = this.getErrorResponse(0, e);
        if (response == null) {
            throw new IllegalStateException("Error counts could not be obtained for request " + this);
        }
        return response.errorCounts();
    }

    public static RequestAndSize parseRequest(ApiKeys apiKey, short apiVersion, ByteBuffer buffer) {
        int bufferSize = buffer.remaining();
        return new RequestAndSize(AbstractRequest.doParseRequest(apiKey, apiVersion, buffer), bufferSize);
    }

    private static AbstractRequest doParseRequest(ApiKeys apiKey, short apiVersion, ByteBuffer buffer) {
        switch (apiKey) {
            case PRODUCE: {
                return ProduceRequest.parse(buffer, apiVersion);
            }
            case FETCH: {
                return FetchRequest.parse(buffer, apiVersion);
            }
            case LIST_OFFSETS: {
                return ListOffsetsRequest.parse(buffer, apiVersion);
            }
            case METADATA: {
                return MetadataRequest.parse(buffer, apiVersion);
            }
            case OFFSET_COMMIT: {
                return OffsetCommitRequest.parse(buffer, apiVersion);
            }
            case OFFSET_FETCH: {
                return OffsetFetchRequest.parse(buffer, apiVersion);
            }
            case FIND_COORDINATOR: {
                return FindCoordinatorRequest.parse(buffer, apiVersion);
            }
            case JOIN_GROUP: {
                return JoinGroupRequest.parse(buffer, apiVersion);
            }
            case HEARTBEAT: {
                return HeartbeatRequest.parse(buffer, apiVersion);
            }
            case LEAVE_GROUP: {
                return LeaveGroupRequest.parse(buffer, apiVersion);
            }
            case SYNC_GROUP: {
                return SyncGroupRequest.parse(buffer, apiVersion);
            }
            case STOP_REPLICA: {
                return StopReplicaRequest.parse(buffer, apiVersion);
            }
            case CONTROLLED_SHUTDOWN: {
                return ControlledShutdownRequest.parse(buffer, apiVersion);
            }
            case UPDATE_METADATA: {
                return UpdateMetadataRequest.parse(buffer, apiVersion);
            }
            case LEADER_AND_ISR: {
                return LeaderAndIsrRequest.parse(buffer, apiVersion);
            }
            case DESCRIBE_GROUPS: {
                return DescribeGroupsRequest.parse(buffer, apiVersion);
            }
            case LIST_GROUPS: {
                return ListGroupsRequest.parse(buffer, apiVersion);
            }
            case SASL_HANDSHAKE: {
                return SaslHandshakeRequest.parse(buffer, apiVersion);
            }
            case API_VERSIONS: {
                return ApiVersionsRequest.parse(buffer, apiVersion);
            }
            case CREATE_TOPICS: {
                return CreateTopicsRequest.parse(buffer, apiVersion);
            }
            case DELETE_TOPICS: {
                return DeleteTopicsRequest.parse(buffer, apiVersion);
            }
            case DELETE_RECORDS: {
                return DeleteRecordsRequest.parse(buffer, apiVersion);
            }
            case INIT_PRODUCER_ID: {
                return InitProducerIdRequest.parse(buffer, apiVersion);
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                return OffsetsForLeaderEpochRequest.parse(buffer, apiVersion);
            }
            case ADD_PARTITIONS_TO_TXN: {
                return AddPartitionsToTxnRequest.parse(buffer, apiVersion);
            }
            case ADD_OFFSETS_TO_TXN: {
                return AddOffsetsToTxnRequest.parse(buffer, apiVersion);
            }
            case END_TXN: {
                return EndTxnRequest.parse(buffer, apiVersion);
            }
            case WRITE_TXN_MARKERS: {
                return WriteTxnMarkersRequest.parse(buffer, apiVersion);
            }
            case TXN_OFFSET_COMMIT: {
                return TxnOffsetCommitRequest.parse(buffer, apiVersion);
            }
            case DESCRIBE_ACLS: {
                return DescribeAclsRequest.parse(buffer, apiVersion);
            }
            case CREATE_ACLS: {
                return CreateAclsRequest.parse(buffer, apiVersion);
            }
            case DELETE_ACLS: {
                return DeleteAclsRequest.parse(buffer, apiVersion);
            }
            case DESCRIBE_CONFIGS: {
                return DescribeConfigsRequest.parse(buffer, apiVersion);
            }
            case ALTER_CONFIGS: {
                return AlterConfigsRequest.parse(buffer, apiVersion);
            }
            case ALTER_REPLICA_LOG_DIRS: {
                return AlterReplicaLogDirsRequest.parse(buffer, apiVersion);
            }
            case DESCRIBE_LOG_DIRS: {
                return DescribeLogDirsRequest.parse(buffer, apiVersion);
            }
            case SASL_AUTHENTICATE: {
                return SaslAuthenticateRequest.parse(buffer, apiVersion);
            }
            case CREATE_PARTITIONS: {
                return CreatePartitionsRequest.parse(buffer, apiVersion);
            }
            case CREATE_DELEGATION_TOKEN: {
                return CreateDelegationTokenRequest.parse(buffer, apiVersion);
            }
            case RENEW_DELEGATION_TOKEN: {
                return RenewDelegationTokenRequest.parse(buffer, apiVersion);
            }
            case EXPIRE_DELEGATION_TOKEN: {
                return ExpireDelegationTokenRequest.parse(buffer, apiVersion);
            }
            case DESCRIBE_DELEGATION_TOKEN: {
                return DescribeDelegationTokenRequest.parse(buffer, apiVersion);
            }
            case DELETE_GROUPS: {
                return DeleteGroupsRequest.parse(buffer, apiVersion);
            }
            case ELECT_LEADERS: {
                return ElectLeadersRequest.parse(buffer, apiVersion);
            }
            case INCREMENTAL_ALTER_CONFIGS: {
                return IncrementalAlterConfigsRequest.parse(buffer, apiVersion);
            }
            case ALTER_PARTITION_REASSIGNMENTS: {
                return AlterPartitionReassignmentsRequest.parse(buffer, apiVersion);
            }
            case LIST_PARTITION_REASSIGNMENTS: {
                return ListPartitionReassignmentsRequest.parse(buffer, apiVersion);
            }
            case OFFSET_DELETE: {
                return OffsetDeleteRequest.parse(buffer, apiVersion);
            }
            case DESCRIBE_CLIENT_QUOTAS: {
                return DescribeClientQuotasRequest.parse(buffer, apiVersion);
            }
            case ALTER_CLIENT_QUOTAS: {
                return AlterClientQuotasRequest.parse(buffer, apiVersion);
            }
            case DESCRIBE_USER_SCRAM_CREDENTIALS: {
                return DescribeUserScramCredentialsRequest.parse(buffer, apiVersion);
            }
            case ALTER_USER_SCRAM_CREDENTIALS: {
                return AlterUserScramCredentialsRequest.parse(buffer, apiVersion);
            }
            case VOTE: {
                return VoteRequest.parse(buffer, apiVersion);
            }
            case BEGIN_QUORUM_EPOCH: {
                return BeginQuorumEpochRequest.parse(buffer, apiVersion);
            }
            case END_QUORUM_EPOCH: {
                return EndQuorumEpochRequest.parse(buffer, apiVersion);
            }
            case DESCRIBE_QUORUM: {
                return DescribeQuorumRequest.parse(buffer, apiVersion);
            }
            case ALTER_ISR: {
                return AlterIsrRequest.parse(buffer, apiVersion);
            }
            case UPDATE_FEATURES: {
                return UpdateFeaturesRequest.parse(buffer, apiVersion);
            }
            case ENVELOPE: {
                return EnvelopeRequest.parse(buffer, apiVersion);
            }
            case FETCH_SNAPSHOT: {
                return FetchSnapshotRequest.parse(buffer, apiVersion);
            }
            case DESCRIBE_CLUSTER: {
                return DescribeClusterRequest.parse(buffer, apiVersion);
            }
            case DESCRIBE_PRODUCERS: {
                return DescribeProducersRequest.parse(buffer, apiVersion);
            }
            case BROKER_REGISTRATION: {
                return BrokerRegistrationRequest.parse(buffer, apiVersion);
            }
            case BROKER_HEARTBEAT: {
                return BrokerHeartbeatRequest.parse(buffer, apiVersion);
            }
            case UNREGISTER_BROKER: {
                return UnregisterBrokerRequest.parse(buffer, apiVersion);
            }
        }
        throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `parseRequest`, the code should be updated to do so.", new Object[]{apiKey}));
    }

    public static abstract class Builder<T extends AbstractRequest> {
        private final ApiKeys apiKey;
        private final short oldestAllowedVersion;
        private final short latestAllowedVersion;

        public Builder(ApiKeys apiKey) {
            this(apiKey, apiKey.oldestVersion(), apiKey.latestVersion());
        }

        public Builder(ApiKeys apiKey, short allowedVersion) {
            this(apiKey, allowedVersion, allowedVersion);
        }

        public Builder(ApiKeys apiKey, short oldestAllowedVersion, short latestAllowedVersion) {
            this.apiKey = apiKey;
            this.oldestAllowedVersion = oldestAllowedVersion;
            this.latestAllowedVersion = latestAllowedVersion;
        }

        public ApiKeys apiKey() {
            return this.apiKey;
        }

        public short oldestAllowedVersion() {
            return this.oldestAllowedVersion;
        }

        public short latestAllowedVersion() {
            return this.latestAllowedVersion;
        }

        public T build() {
            return this.build(this.latestAllowedVersion());
        }

        public abstract T build(short var1);
    }
}

