/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.TopicPartition;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class AlterReplicaLogDirsRequest
extends AbstractRequest {
    private final AlterReplicaLogDirsRequestData data;

    public AlterReplicaLogDirsRequest(AlterReplicaLogDirsRequestData data, short version) {
        super(ApiKeys.ALTER_REPLICA_LOG_DIRS, version);
        this.data = data;
    }

    @Override
    public AlterReplicaLogDirsRequestData data() {
        return this.data;
    }

    @Override
    public AlterReplicaLogDirsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        AlterReplicaLogDirsResponseData data = new AlterReplicaLogDirsResponseData();
        data.setResults(this.data.dirs().stream().flatMap(alterDir -> alterDir.topics().stream().map(topic -> new AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult().setTopicName(topic.name()).setPartitions(topic.partitions().stream().map(partitionId -> new AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult().setErrorCode(Errors.forException(e).code()).setPartitionIndex((int)partitionId)).collect(Collectors.toList())))).collect(Collectors.toList()));
        return new AlterReplicaLogDirsResponse(data.setThrottleTimeMs(throttleTimeMs));
    }

    public Map<TopicPartition, String> partitionDirs() {
        HashMap<TopicPartition, String> result = new HashMap<TopicPartition, String>();
        this.data.dirs().forEach(alterDir -> alterDir.topics().forEach(topic -> topic.partitions().forEach(partition -> result.put(new TopicPartition(topic.name(), (int)partition), alterDir.path()))));
        return result;
    }

    public static AlterReplicaLogDirsRequest parse(ByteBuffer buffer, short version) {
        return new AlterReplicaLogDirsRequest(new AlterReplicaLogDirsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterReplicaLogDirsRequest> {
        private final AlterReplicaLogDirsRequestData data;

        public Builder(AlterReplicaLogDirsRequestData data) {
            super(ApiKeys.ALTER_REPLICA_LOG_DIRS);
            this.data = data;
        }

        @Override
        public AlterReplicaLogDirsRequest build(short version) {
            return new AlterReplicaLogDirsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

