/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.Node;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.InvalidRequestException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.FindCoordinatorRequestData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.FindCoordinatorResponseData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.FindCoordinatorResponse;
import java.nio.ByteBuffer;

public class FindCoordinatorRequest
extends AbstractRequest {
    private final FindCoordinatorRequestData data;

    private FindCoordinatorRequest(FindCoordinatorRequestData data, short version) {
        super(ApiKeys.FIND_COORDINATOR, version);
        this.data = data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        FindCoordinatorResponseData response = new FindCoordinatorResponseData();
        if (this.version() >= 2) {
            response.setThrottleTimeMs(throttleTimeMs);
        }
        Errors error = Errors.forException(e);
        return FindCoordinatorResponse.prepareResponse(error, Node.noNode());
    }

    public static FindCoordinatorRequest parse(ByteBuffer buffer, short version) {
        return new FindCoordinatorRequest(new FindCoordinatorRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public FindCoordinatorRequestData data() {
        return this.data;
    }

    public static enum CoordinatorType {
        GROUP(0),
        TRANSACTION(1);

        final byte id;

        private CoordinatorType(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static CoordinatorType forId(byte id) {
            switch (id) {
                case 0: {
                    return GROUP;
                }
                case 1: {
                    return TRANSACTION;
                }
            }
            throw new InvalidRequestException("Unknown coordinator type received: " + id);
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<FindCoordinatorRequest> {
        private final FindCoordinatorRequestData data;

        public Builder(FindCoordinatorRequestData data) {
            super(ApiKeys.FIND_COORDINATOR);
            this.data = data;
        }

        @Override
        public FindCoordinatorRequest build(short version) {
            if (version < 1 && this.data.keyType() == CoordinatorType.TRANSACTION.id()) {
                throw new UnsupportedVersionException("Cannot create a v" + version + " FindCoordinator request because we require features supported only in 2 or later.");
            }
            return new FindCoordinatorRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }

        public FindCoordinatorRequestData data() {
            return this.data;
        }
    }
}

