/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.SaslHandshakeRequestData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.SaslHandshakeResponseData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.ApiError;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.SaslHandshakeResponse;
import java.nio.ByteBuffer;

public class SaslHandshakeRequest
extends AbstractRequest {
    private final SaslHandshakeRequestData data;

    public SaslHandshakeRequest(SaslHandshakeRequestData data, short version) {
        super(ApiKeys.SASL_HANDSHAKE, version);
        this.data = data;
    }

    @Override
    public SaslHandshakeRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        SaslHandshakeResponseData response = new SaslHandshakeResponseData();
        response.setErrorCode(ApiError.fromThrowable(e).error().code());
        return new SaslHandshakeResponse(response);
    }

    public static SaslHandshakeRequest parse(ByteBuffer buffer, short version) {
        return new SaslHandshakeRequest(new SaslHandshakeRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<SaslHandshakeRequest> {
        private final SaslHandshakeRequestData data;

        public Builder(SaslHandshakeRequestData data) {
            super(ApiKeys.SASL_HANDSHAKE);
            this.data = data;
        }

        @Override
        public SaslHandshakeRequest build(short version) {
            return new SaslHandshakeRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

