/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.TopicPartition;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message.WriteTxnMarkersResponseData;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WriteTxnMarkersResponse
extends AbstractResponse {
    private final WriteTxnMarkersResponseData data;

    public WriteTxnMarkersResponse(Map<Long, Map<TopicPartition, Errors>> errors) {
        super(ApiKeys.WRITE_TXN_MARKERS);
        ArrayList<WriteTxnMarkersResponseData.WritableTxnMarkerResult> markers = new ArrayList<WriteTxnMarkersResponseData.WritableTxnMarkerResult>();
        for (Map.Entry<Long, Map<TopicPartition, Errors>> markerEntry : errors.entrySet()) {
            HashMap<String, WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult> responseTopicDataMap = new HashMap<String, WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult>();
            for (Map.Entry<TopicPartition, Errors> topicEntry : markerEntry.getValue().entrySet()) {
                TopicPartition topicPartition = topicEntry.getKey();
                String topicName = topicPartition.topic();
                WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult topic = responseTopicDataMap.getOrDefault(topicName, new WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult().setName(topicName));
                topic.partitions().add(new WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult().setErrorCode(topicEntry.getValue().code()).setPartitionIndex(topicPartition.partition()));
                responseTopicDataMap.put(topicName, topic);
            }
            markers.add(new WriteTxnMarkersResponseData.WritableTxnMarkerResult().setProducerId(markerEntry.getKey()).setTopics(new ArrayList<WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult>(responseTopicDataMap.values())));
        }
        this.data = new WriteTxnMarkersResponseData().setMarkers(markers);
    }

    public WriteTxnMarkersResponse(WriteTxnMarkersResponseData data) {
        super(ApiKeys.WRITE_TXN_MARKERS);
        this.data = data;
    }

    @Override
    public WriteTxnMarkersResponseData data() {
        return this.data;
    }

    public Map<Long, Map<TopicPartition, Errors>> errorsByProducerId() {
        HashMap<Long, Map<TopicPartition, Errors>> errors = new HashMap<Long, Map<TopicPartition, Errors>>();
        for (WriteTxnMarkersResponseData.WritableTxnMarkerResult marker : this.data.markers()) {
            HashMap<TopicPartition, Errors> topicPartitionErrorsMap = new HashMap<TopicPartition, Errors>();
            for (WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult topic : marker.topics()) {
                for (WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult partitionResult : topic.partitions()) {
                    topicPartitionErrorsMap.put(new TopicPartition(topic.name(), partitionResult.partitionIndex()), Errors.forCode(partitionResult.errorCode()));
                }
            }
            errors.put(marker.producerId(), topicPartitionErrorsMap);
        }
        return errors;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (WriteTxnMarkersResponseData.WritableTxnMarkerResult marker : this.data.markers()) {
            for (WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult topic : marker.topics()) {
                for (WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult partitionResult : topic.partitions()) {
                    this.updateErrorCounts(errorCounts, Errors.forCode(partitionResult.errorCode()));
                }
            }
        }
        return errorCounts;
    }

    public static WriteTxnMarkersResponse parse(ByteBuffer buffer, short version) {
        return new WriteTxnMarkersResponse(new WriteTxnMarkersResponseData(new ByteBufferAccessor(buffer), version));
    }
}

