/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import java.io.Serializable;

public class OAuthBearerValidationResult
implements Serializable {
    private static final long serialVersionUID = 5774669940899777373L;
    private final boolean success;
    private final String failureDescription;
    private final String failureScope;
    private final String failureOpenIdConfig;

    public static OAuthBearerValidationResult newSuccess() {
        return new OAuthBearerValidationResult(true, null, null, null);
    }

    public static OAuthBearerValidationResult newFailure(String failureDescription) {
        return OAuthBearerValidationResult.newFailure(failureDescription, null, null);
    }

    public static OAuthBearerValidationResult newFailure(String failureDescription, String failureScope, String failureOpenIdConfig) {
        return new OAuthBearerValidationResult(false, failureDescription, failureScope, failureOpenIdConfig);
    }

    private OAuthBearerValidationResult(boolean success, String failureDescription, String failureScope, String failureOpenIdConfig) {
        if (success && (failureScope != null || failureOpenIdConfig != null)) {
            throw new IllegalArgumentException("success was indicated but failure scope/OpenIdConfig were provided");
        }
        this.success = success;
        this.failureDescription = failureDescription;
        this.failureScope = failureScope;
        this.failureOpenIdConfig = failureOpenIdConfig;
    }

    public boolean success() {
        return this.success;
    }

    public String failureDescription() {
        return this.failureDescription;
    }

    public String failureScope() {
        return this.failureScope;
    }

    public String failureOpenIdConfig() {
        return this.failureOpenIdConfig;
    }

    public void throwExceptionIfFailed() throws OAuthBearerIllegalTokenException {
        if (!this.success()) {
            throw new OAuthBearerIllegalTokenException(this);
        }
    }
}

