/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.token.delegation.internals;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.authenticator.CredentialCache;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.scram.ScramCredential;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.scram.internals.ScramMechanism;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.token.delegation.DelegationToken;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.security.token.delegation.TokenInformation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DelegationTokenCache {
    private CredentialCache credentialCache = new CredentialCache();
    private Map<String, TokenInformation> tokenCache = new ConcurrentHashMap<String, TokenInformation>();
    private Map<String, String> hmacTokenIdCache = new ConcurrentHashMap<String, String>();
    private Map<String, String> tokenIdHmacCache = new ConcurrentHashMap<String, String>();

    public DelegationTokenCache(Collection<String> scramMechanisms) {
        ScramCredentialUtils.createCache(this.credentialCache, scramMechanisms);
    }

    public ScramCredential credential(String mechanism, String tokenId) {
        CredentialCache.Cache<ScramCredential> cache = this.credentialCache.cache(mechanism, ScramCredential.class);
        return cache == null ? null : cache.get(tokenId);
    }

    public String owner(String tokenId) {
        TokenInformation tokenInfo = this.tokenCache.get(tokenId);
        return tokenInfo == null ? null : tokenInfo.owner().getName();
    }

    public void updateCache(DelegationToken token, Map<String, ScramCredential> scramCredentialMap) {
        String tokenId = token.tokenInfo().tokenId();
        this.addToken(tokenId, token.tokenInfo());
        String hmac = token.hmacAsBase64String();
        this.updateCredentials(tokenId, scramCredentialMap);
        this.hmacTokenIdCache.put(hmac, tokenId);
        this.tokenIdHmacCache.put(tokenId, hmac);
    }

    public void removeCache(String tokenId) {
        this.removeToken(tokenId);
        this.updateCredentials(tokenId, new HashMap<String, ScramCredential>());
    }

    public String tokenIdForHmac(String base64hmac) {
        return this.hmacTokenIdCache.get(base64hmac);
    }

    public TokenInformation tokenForHmac(String base64hmac) {
        String tokenId = this.hmacTokenIdCache.get(base64hmac);
        return tokenId == null ? null : this.tokenCache.get(tokenId);
    }

    public TokenInformation addToken(String tokenId, TokenInformation tokenInfo) {
        return this.tokenCache.put(tokenId, tokenInfo);
    }

    public void removeToken(String tokenId) {
        String hmac;
        TokenInformation tokenInfo = this.tokenCache.remove(tokenId);
        if (tokenInfo != null && (hmac = this.tokenIdHmacCache.remove(tokenInfo.tokenId())) != null) {
            this.hmacTokenIdCache.remove(hmac);
        }
    }

    public Collection<TokenInformation> tokens() {
        return this.tokenCache.values();
    }

    public TokenInformation token(String tokenId) {
        return this.tokenCache.get(tokenId);
    }

    public CredentialCache.Cache<ScramCredential> credentialCache(String mechanism) {
        return this.credentialCache.cache(mechanism, ScramCredential.class);
    }

    private void updateCredentials(String tokenId, Map<String, ScramCredential> scramCredentialMap) {
        for (String mechanism : ScramMechanism.mechanismNames()) {
            CredentialCache.Cache<ScramCredential> cache = this.credentialCache.cache(mechanism, ScramCredential.class);
            if (cache == null) continue;
            ScramCredential credential = scramCredentialMap.get(mechanism);
            if (credential == null) {
                cache.remove(tokenId);
                continue;
            }
            cache.put(tokenId, credential);
        }
    }
}

