/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils;

import java.nio.ByteBuffer;
import java.util.zip.Checksum;

public final class Checksums {
    private Checksums() {
    }

    public static void update(Checksum checksum, ByteBuffer buffer, int length) {
        Checksums.update(checksum, buffer, 0, length);
    }

    public static void update(Checksum checksum, ByteBuffer buffer, int offset, int length) {
        if (buffer.hasArray()) {
            checksum.update(buffer.array(), buffer.position() + buffer.arrayOffset() + offset, length);
        } else {
            int start;
            for (int i = start = buffer.position() + offset; i < start + length; ++i) {
                checksum.update(buffer.get(i));
            }
        }
    }

    public static void updateInt(Checksum checksum, int input) {
        checksum.update((byte)(input >> 24));
        checksum.update((byte)(input >> 16));
        checksum.update((byte)(input >> 8));
        checksum.update((byte)input);
    }

    public static void updateLong(Checksum checksum, long input) {
        checksum.update((byte)(input >> 56));
        checksum.update((byte)(input >> 48));
        checksum.update((byte)(input >> 40));
        checksum.update((byte)(input >> 32));
        checksum.update((byte)(input >> 24));
        checksum.update((byte)(input >> 16));
        checksum.update((byte)(input >> 8));
        checksum.update((byte)input);
    }
}

