/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.xerial.snappy.pure;

import cz.o2.proxima.kafka.shaded.org.xerial.snappy.SnappyApi;
import cz.o2.proxima.kafka.shaded.org.xerial.snappy.pure.SnappyRawCompressor;
import cz.o2.proxima.kafka.shaded.org.xerial.snappy.pure.SnappyRawDecompressor;
import cz.o2.proxima.kafka.shaded.org.xerial.snappy.pure.UnsafeUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public class PureJavaSnappy
implements SnappyApi {
    private final short[] table = new short[16384];
    private static final int MAX_OUTPUT_LENGTH = Integer.MAX_VALUE;

    @Override
    public long rawCompress(long l, long l2, long l3) throws IOException {
        return SnappyRawCompressor.compress(null, l, l2, null, l3, Integer.MAX_VALUE, this.table);
    }

    @Override
    public long rawUncompress(long l, long l2, long l3) throws IOException {
        return SnappyRawDecompressor.decompress(null, l, l2, null, l3, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rawCompress(ByteBuffer byteBuffer, int n, int n2, ByteBuffer byteBuffer2, int n3) throws IOException {
        long l;
        long l2;
        byte[] byArray;
        long l3;
        long l4;
        byte[] byArray2;
        if (byteBuffer.isDirect()) {
            byArray2 = null;
            long l5 = UnsafeUtil.getAddress(byteBuffer);
            l4 = l5 + (long)byteBuffer.position();
            l3 = l5 + (long)byteBuffer.limit();
        } else if (byteBuffer.hasArray()) {
            byArray2 = byteBuffer.array();
            l4 = Unsafe.ARRAY_BYTE_BASE_OFFSET + byteBuffer.arrayOffset() + byteBuffer.position();
            l3 = Unsafe.ARRAY_BYTE_BASE_OFFSET + byteBuffer.arrayOffset() + byteBuffer.limit();
        } else {
            throw new IllegalArgumentException("Unsupported input ByteBuffer implementation " + byteBuffer.getClass().getName());
        }
        if (byteBuffer2.isDirect()) {
            byArray = null;
            long l6 = UnsafeUtil.getAddress(byteBuffer2);
            l2 = l6 + (long)byteBuffer2.position();
            l = l6 + (long)byteBuffer2.limit();
        } else if (byteBuffer2.hasArray()) {
            byArray = byteBuffer2.array();
            l2 = Unsafe.ARRAY_BYTE_BASE_OFFSET + byteBuffer2.arrayOffset() + byteBuffer2.position();
            l = Unsafe.ARRAY_BYTE_BASE_OFFSET + byteBuffer2.arrayOffset() + byteBuffer2.limit();
        } else {
            throw new IllegalArgumentException("Unsupported output ByteBuffer implementation " + byteBuffer2.getClass().getName());
        }
        ByteBuffer byteBuffer3 = byteBuffer;
        synchronized (byteBuffer3) {
            ByteBuffer byteBuffer4 = byteBuffer2;
            synchronized (byteBuffer4) {
                int n4 = SnappyRawCompressor.compress(byArray2, l4, l3, byArray, l2, l, this.table);
                byteBuffer2.position(byteBuffer2.position() + n4);
                return n4;
            }
        }
    }

    @Override
    public int rawCompress(Object object, int n, int n2, Object object2, int n3) throws IOException {
        long l = Unsafe.ARRAY_BYTE_BASE_OFFSET + n;
        long l2 = l + (long)n2;
        long l3 = Unsafe.ARRAY_BYTE_BASE_OFFSET + n3;
        long l4 = l3 + Integer.MAX_VALUE;
        return SnappyRawCompressor.compress(object, l, l2, object2, l3, l4, this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rawUncompress(ByteBuffer byteBuffer, int n, int n2, ByteBuffer byteBuffer2, int n3) throws IOException {
        long l;
        long l2;
        byte[] byArray;
        long l3;
        long l4;
        byte[] byArray2;
        if (byteBuffer.isDirect()) {
            byArray2 = null;
            long l5 = UnsafeUtil.getAddress(byteBuffer);
            l4 = l5 + (long)byteBuffer.position();
            l3 = l5 + (long)byteBuffer.limit();
        } else if (byteBuffer.hasArray()) {
            byArray2 = byteBuffer.array();
            l4 = Unsafe.ARRAY_BYTE_BASE_OFFSET + byteBuffer.arrayOffset() + byteBuffer.position();
            l3 = Unsafe.ARRAY_BYTE_BASE_OFFSET + byteBuffer.arrayOffset() + byteBuffer.limit();
        } else {
            throw new IllegalArgumentException("Unsupported input ByteBuffer implementation " + byteBuffer.getClass().getName());
        }
        if (byteBuffer2.isDirect()) {
            byArray = null;
            long l6 = UnsafeUtil.getAddress(byteBuffer2);
            l2 = l6 + (long)byteBuffer2.position();
            l = l6 + (long)byteBuffer2.limit();
        } else if (byteBuffer2.hasArray()) {
            byArray = byteBuffer2.array();
            l2 = Unsafe.ARRAY_BYTE_BASE_OFFSET + byteBuffer2.arrayOffset() + byteBuffer2.position();
            l = Unsafe.ARRAY_BYTE_BASE_OFFSET + byteBuffer2.arrayOffset() + byteBuffer2.limit();
        } else {
            throw new IllegalArgumentException("Unsupported output ByteBuffer implementation " + byteBuffer2.getClass().getName());
        }
        ByteBuffer byteBuffer3 = byteBuffer;
        synchronized (byteBuffer3) {
            ByteBuffer byteBuffer4 = byteBuffer2;
            synchronized (byteBuffer4) {
                int n4 = SnappyRawDecompressor.decompress(byArray2, l4, l3, byArray, l2, l);
                byteBuffer2.position(byteBuffer2.position() + n4);
                return n4;
            }
        }
    }

    @Override
    public int rawUncompress(Object object, int n, int n2, Object object2, int n3) throws IOException {
        long l = Unsafe.ARRAY_BYTE_BASE_OFFSET + n;
        long l2 = l + (long)n2;
        long l3 = Unsafe.ARRAY_BYTE_BASE_OFFSET + n3;
        long l4 = l3 + Integer.MAX_VALUE;
        return SnappyRawDecompressor.decompress(object, l, l2, object2, l3, l4);
    }

    @Override
    public int maxCompressedLength(int n) {
        return SnappyRawCompressor.maxCompressedLength(n);
    }

    @Override
    public int uncompressedLength(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        long l;
        long l2;
        byte[] byArray;
        if (byteBuffer.isDirect()) {
            byArray = null;
            long l3 = UnsafeUtil.getAddress(byteBuffer);
            l2 = l3 + (long)byteBuffer.position();
            l = l3 + (long)byteBuffer.limit();
        } else if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
            l2 = Unsafe.ARRAY_BYTE_BASE_OFFSET + n;
            l = Unsafe.ARRAY_BYTE_BASE_OFFSET + n2;
        } else {
            throw new IllegalArgumentException("Unsupported input ByteBuffer implementation: " + byteBuffer.getClass().getName());
        }
        return SnappyRawDecompressor.getUncompressedLength(byArray, l2, l);
    }

    @Override
    public int uncompressedLength(Object object, int n, int n2) throws IOException {
        long l = Unsafe.ARRAY_BYTE_BASE_OFFSET + n;
        long l2 = Unsafe.ARRAY_BYTE_BASE_OFFSET + n2;
        return SnappyRawDecompressor.getUncompressedLength(object, l, l2);
    }

    @Override
    public long uncompressedLength(long l, long l2) throws IOException {
        return SnappyRawDecompressor.getUncompressedLength(null, l, l + l2);
    }

    @Override
    public boolean isValidCompressedBuffer(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        throw new UnsupportedOperationException("isValidCompressedBuffer is not supported in pure-java mode");
    }

    @Override
    public boolean isValidCompressedBuffer(Object object, int n, int n2) throws IOException {
        throw new UnsupportedOperationException("isValidCompressedBuffer is not supported in pure-java mode");
    }

    @Override
    public boolean isValidCompressedBuffer(long l, long l2, long l3) throws IOException {
        throw new UnsupportedOperationException("isValidCompressedBuffer is not supported in pure-java mode");
    }

    @Override
    public void arrayCopy(Object object, int n, int n2, Object object2, int n3) throws IOException {
        System.arraycopy(object, n, object2, n3, n2);
    }
}

