/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.xerial.snappy.pure;

import cz.o2.proxima.kafka.shaded.org.xerial.snappy.SnappyError;
import cz.o2.proxima.kafka.shaded.org.xerial.snappy.SnappyErrorCode;
import java.lang.reflect.Field;
import java.nio.Buffer;
import sun.misc.Unsafe;

final class UnsafeUtil {
    public static final Unsafe UNSAFE;
    private static final Field ADDRESS_ACCESSOR;

    private UnsafeUtil() {
    }

    public static long getAddress(Buffer buffer) {
        try {
            return (Long)ADDRESS_ACCESSOR.get(buffer);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    static {
        Field field;
        try {
            field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
        }
        catch (Exception exception) {
            throw new SnappyError(SnappyErrorCode.UNSUPPORTED_PLATFORM, "pure-java snappy requires access to sun.misc.Unsafe");
        }
        try {
            field = Buffer.class.getDeclaredField("address");
            field.setAccessible(true);
            ADDRESS_ACCESSOR = field;
        }
        catch (Exception exception) {
            throw new SnappyError(SnappyErrorCode.UNSUPPORTED_PLATFORM, "pure-java snappy requires access to java.nio.Buffer raw address field");
        }
    }
}

