/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.kafka;

import cz.o2.proxima.direct.kafka.PartitionWithTopic;
import cz.o2.proxima.functional.UnaryFunction;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.TopicPartition;
import cz.o2.proxima.storage.Partition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerGroup
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ConsumerGroup.class);
    private static final long serialVersionUID = 1L;
    final String name;
    final String topic;
    final int numPartitions;
    final boolean autoRelalance;
    final NavigableMap<Integer, Assignment> assignments = new TreeMap<Integer, Assignment>();

    ConsumerGroup(String name, String topic, int numPartitions, boolean autoRebalance) {
        this.name = name;
        this.topic = topic;
        this.numPartitions = numPartitions;
        this.autoRelalance = autoRebalance;
        if (numPartitions <= 0) {
            throw new IllegalArgumentException("Number of partitions must be strictly positive");
        }
    }

    public synchronized int add() {
        return this.add((ConsumerRebalanceListener)null);
    }

    public synchronized int add(@Nullable ConsumerRebalanceListener listener) {
        log.debug("Adding new consumer to group {} with assignments {}", (Object)this.name, this.assignments);
        return this.addWithNoAssignment((UnaryFunction<Integer, Assignment>)(UnaryFunction & Serializable)id -> new Assignment((int)id, listener));
    }

    public synchronized int add(Collection<Partition> partitions) {
        int id = this.addWithNoAssignment((UnaryFunction<Integer, Assignment>)(UnaryFunction & Serializable)tmp -> new Assignment((int)tmp, null));
        ((Assignment)this.assignments.get(id)).assign(partitions);
        return id;
    }

    private int addWithNoAssignment(UnaryFunction<Integer, Assignment> assignFactory) {
        int id = this.assignments.isEmpty() ? 0 : (Integer)this.assignments.lastKey() + 1;
        this.assignments.put(id, (Assignment)assignFactory.apply((Object)id));
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rebalanceIfNeeded() {
        if (this.isAutoRelalance()) {
            log.info("(re-)joining group {}", (Object)this.name);
            ConsumerGroup consumerGroup = this;
            synchronized (consumerGroup) {
                this.assign(this.assignments);
                return true;
            }
        }
        return false;
    }

    public synchronized void remove(int id) {
        Assignment removed = (Assignment)this.assignments.remove(id);
        if (removed != null) {
            removed.drop();
            this.assign(this.assignments);
        }
    }

    private void assign(NavigableMap<Integer, Assignment> assignments) {
        if (!assignments.isEmpty()) {
            assignments.values().forEach(Assignment::drop);
            double equalShare = (double)this.numPartitions / (double)assignments.size();
            double shared = 0.0;
            int partition = 0;
            Iterator iter = assignments.entrySet().iterator();
            while (partition < this.numPartitions && iter.hasNext()) {
                Map.Entry next = iter.next();
                ArrayList<Partition> partitions = new ArrayList<Partition>();
                int last = (int)(shared += equalShare);
                while (partition < last) {
                    int partitionId = partition++;
                    partitions.add((Partition)new PartitionWithTopic(this.topic, partitionId));
                }
                ((Assignment)next.getValue()).assign(partitions);
            }
        }
    }

    synchronized void assign(int id, List<Partition> assignment) {
        Assignment current = (Assignment)this.assignments.get(id);
        current.drop();
        current.assign(assignment);
    }

    synchronized Collection<Partition> getAssignment(int id) {
        Assignment assignment = (Assignment)this.assignments.get(id);
        if (assignment != null) {
            return assignment.getPartitions();
        }
        return Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public boolean isAutoRelalance() {
        return this.autoRelalance;
    }

    class Assignment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final int id;
        final ConsumerRebalanceListener listener;
        final Collection<Partition> partitions = new ArrayList<Partition>();

        Assignment(int id, ConsumerRebalanceListener listener) {
            this.id = id;
            this.listener = listener != null ? listener : new ConsumerRebalanceListener(){

                public void onPartitionsRevoked(Collection<TopicPartition> clctn) {
                }

                public void onPartitionsAssigned(Collection<TopicPartition> clctn) {
                }
            };
        }

        void drop() {
            this.listener.onPartitionsRevoked((Collection)this.partitions.stream().map(p -> new TopicPartition(ConsumerGroup.this.topic, p.getId())).collect(Collectors.toList()));
            this.partitions.clear();
        }

        void assign(Collection<Partition> assign) {
            this.partitions.clear();
            this.partitions.addAll(assign);
            List tps = this.partitions.stream().map(p -> new TopicPartition(ConsumerGroup.this.topic, p.getId())).collect(Collectors.toList());
            this.listener.onPartitionsAssigned(tps);
            log.debug("Assigned partitions {} to consumer ID {} of group {}, notifying listener {}", new Object[]{tps, this.id, ConsumerGroup.this.name, this.listener});
        }

        public String toString() {
            return "ConsumerGroup.Assignment(id=" + this.getId() + ", listener=" + this.getListener() + ", partitions=" + this.getPartitions() + ")";
        }

        public int getId() {
            return this.id;
        }

        public ConsumerRebalanceListener getListener() {
            return this.listener;
        }

        public Collection<Partition> getPartitions() {
            return this.partitions;
        }
    }
}

