/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.kafka;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import cz.o2.proxima.direct.kafka.ElementSerializer;
import cz.o2.proxima.direct.kafka.KafkaStreamElement;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.producer.ProducerRecord;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.TimestampType;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.storage.StreamElement;
import org.junit.Assert;
import org.junit.Test;

public class KafkaStreamElementSerializerTest {
    private final Repository repo = Repository.ofTest((Config)ConfigFactory.load((String)"test-reference.conf").resolve(), (Repository.Validate[])new Repository.Validate[0]);
    private final EntityDescriptor gateway = this.repo.getEntity("gateway");
    private final AttributeDescriptor<?> status = this.gateway.getAttribute("status");
    private final ElementSerializer<String, byte[]> serializer = new KafkaStreamElement.KafkaStreamElementSerializer();

    @Test
    public void testSerDe() {
        StreamElement elem = StreamElement.upsert((EntityDescriptor)this.gateway, this.status, (String)"topic#1#0", (String)"key", (String)this.status.getName(), (long)System.currentTimeMillis(), (byte[])new byte[0]);
        ProducerRecord record = this.serializer.write("topic", 1, elem);
        ConsumerRecord read = this.asConsumer(record, 0L);
        StreamElement readElement = this.serializer.read(read, this.gateway);
        Assert.assertEquals((Object)elem, (Object)readElement);
    }

    @Test
    public void testSerDeWithSeqId() {
        StreamElement elem = StreamElement.upsert((EntityDescriptor)this.gateway, this.status, (long)1L, (String)"key", (String)this.status.getName(), (long)System.currentTimeMillis(), (byte[])new byte[0]);
        ProducerRecord record = this.serializer.write("topic", 1, elem);
        ConsumerRecord read = this.asConsumer(record, 0L);
        StreamElement readElement = this.serializer.read(read, this.gateway);
        Assert.assertEquals((Object)elem, (Object)readElement);
    }

    private <K, V> ConsumerRecord<K, V> asConsumer(ProducerRecord<K, V> record, long offset) {
        return new ConsumerRecord(record.topic(), record.partition().intValue(), offset, record.timestamp().longValue(), TimestampType.CREATE_TIME, null, 0, 0, record.key(), record.value(), record.headers());
    }
}

