/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.kafka;

import cz.o2.proxima.direct.kafka.KafkaThroughputLimiter;
import org.junit.Assert;
import org.junit.Test;

public class KafkaThroughputLimiterTest {
    final KafkaThroughputLimiter limiter = new KafkaThroughputLimiter(1000000L);

    @Test
    public void testGetSleepTimeWhenNothingPolled() {
        Assert.assertEquals((long)0L, (long)this.limiter.getSleepTime(0L, 0L));
    }

    @Test
    public void testGetSleepTimeWhenPolledBytesBellowLimit() {
        Assert.assertEquals((long)0L, (long)this.limiter.getSleepTime(1000L, 100L));
    }

    @Test
    public void testGetSleepTimeWhenPolledBytesMatchLimit() {
        Assert.assertEquals((long)0L, (long)this.limiter.getSleepTime(100000L, 100L));
    }

    @Test
    public void testGetSleepTimeWhenPolledBytesExceedLimit() {
        Assert.assertEquals((long)100L, (long)this.limiter.getSleepTime(200000L, 100L));
    }

    @Test
    public void testGetSleepTimeWhenFastPoll() {
        Assert.assertEquals((long)0L, (long)this.limiter.getSleepTime(1000L, 0L));
    }

    @Test
    public void testGetSleepTimeWhenSlowPoll() {
        Assert.assertEquals((long)0L, (long)this.limiter.getSleepTime(1000000L, 10000L));
        Assert.assertEquals((long)0L, (long)this.limiter.getSleepTime(10000000L, 10000L));
        Assert.assertEquals((long)10000L, (long)this.limiter.getSleepTime(20000000L, 10000L));
    }
}

