/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.kafka;

import cz.o2.proxima.direct.kafka.OffsetCommitter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OffsetCommitterTest {
    OffsetCommitter<String> committer;

    @Before
    public void setUp() {
        this.committer = new OffsetCommitter();
    }

    @Test
    public void testSimpleCommit() {
        String id = "dummy-0";
        AtomicBoolean committed = new AtomicBoolean();
        long offset = 1L;
        this.committer.register((Object)id, offset, 5, () -> committed.set(true));
        Assert.assertFalse((boolean)committed.get());
        for (int i = 0; i < 5; ++i) {
            Assert.assertFalse((boolean)committed.get());
            this.committer.confirm((Object)id, offset);
        }
        Assert.assertTrue((boolean)committed.get());
    }

    @Test
    public void testTwoOffsetCommit() {
        int i;
        String id = "dummy-0";
        AtomicLong committed = new AtomicLong();
        long offset = 1L;
        this.committer.register((Object)id, offset, 5, () -> committed.set(offset));
        this.committer.register((Object)id, offset + 1L, 6, () -> committed.set(offset + 1L));
        for (i = 0; i < 6; ++i) {
            this.committer.confirm((Object)id, offset + 1L);
        }
        Assert.assertEquals((long)0L, (long)committed.get());
        for (i = 0; i < 4; ++i) {
            this.committer.confirm((Object)id, offset);
        }
        Assert.assertEquals((long)0L, (long)committed.get());
        this.committer.confirm((Object)id, offset);
        Assert.assertEquals((long)(offset + 1L), (long)committed.get());
    }

    @Test
    public void testFourOffsetCommit() {
        int i;
        String id = "dummy-0";
        AtomicLong committed = new AtomicLong();
        long offset = 1L;
        this.committer.register((Object)id, offset, 5, () -> committed.set(offset));
        this.committer.register((Object)id, offset + 1L, 6, () -> committed.set(offset + 1L));
        this.committer.register((Object)id, offset + 2L, 4, () -> committed.set(offset + 2L));
        this.committer.register((Object)id, offset + 3L, 3, () -> committed.set(offset + 3L));
        for (i = 0; i < 4; ++i) {
            this.committer.confirm((Object)id, offset + 2L);
        }
        Assert.assertEquals((long)0L, (long)committed.get());
        for (i = 0; i < 6; ++i) {
            this.committer.confirm((Object)id, offset + 1L);
        }
        Assert.assertEquals((long)0L, (long)committed.get());
        for (i = 0; i < 5; ++i) {
            this.committer.confirm((Object)id, offset);
        }
        Assert.assertEquals((long)(offset + 2L), (long)committed.get());
    }

    @Test
    public void testCommitWithZeroActionsOnly() {
        String id = "dummy-0";
        AtomicLong committed = new AtomicLong();
        long offset = 1L;
        this.committer.register((Object)id, offset, 0, () -> committed.set(offset));
        Assert.assertEquals((long)offset, (long)committed.get());
    }

    @Test
    public void testCommitWithZeroActions() {
        String id = "dummy-0";
        AtomicLong committed = new AtomicLong();
        long offset = 1L;
        this.committer.register((Object)id, offset, 5, () -> committed.set(offset));
        this.committer.register((Object)id, offset + 1L, 0, () -> committed.set(offset + 1L));
        Assert.assertEquals((long)0L, (long)committed.get());
        for (int i = 0; i < 4; ++i) {
            this.committer.confirm((Object)id, offset);
        }
        Assert.assertEquals((long)0L, (long)committed.get());
        this.committer.confirm((Object)id, offset);
        Assert.assertEquals((long)(offset + 1L), (long)committed.get());
    }

    @Test
    public void testAutoCommit() {
        this.committer = new OffsetCommitter(Long.MAX_VALUE, 1L);
        String id = "dummy-0";
        AtomicBoolean committed = new AtomicBoolean();
        long offset = 1L;
        this.committer.register((Object)id, offset, 5, () -> committed.set(true));
        Assert.assertFalse((boolean)committed.get());
        this.committer.confirm((Object)id, offset);
        Assert.assertTrue((boolean)committed.get());
    }
}

