/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.kafka;

import cz.o2.proxima.direct.commitlog.Offset;
import cz.o2.proxima.direct.kafka.PartitionWithTopic;
import cz.o2.proxima.direct.kafka.TopicOffset;
import cz.o2.proxima.direct.kafka.TopicOffsetExternalizer;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.core.type.TypeReference;
import cz.o2.proxima.kafka.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import cz.o2.proxima.scheme.SerializationException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class TopicOffsetExternalizerTest {
    private final TopicOffsetExternalizer externalizer = new TopicOffsetExternalizer();

    @Test
    public void testToJson() throws JsonProcessingException {
        String json = this.externalizer.toJson((Offset)new TopicOffset(new PartitionWithTopic("topic-1", 1), 1L, 2L));
        HashMap jsonMap = (HashMap)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        Assert.assertEquals((Object)"topic-1", jsonMap.get("topic"));
        Assert.assertEquals((Object)1, jsonMap.get("partition"));
        Assert.assertEquals((Object)1, jsonMap.get("offset"));
        Assert.assertEquals((Object)2, jsonMap.get("watermark"));
    }

    @Test
    public void testFromJson() {
        TopicOffset offset = new TopicOffset(new PartitionWithTopic("topic-1", 1), 1L, 2L);
        Assert.assertEquals((Object)offset, (Object)this.externalizer.fromJson(this.externalizer.toJson((Offset)offset)));
    }

    @Test
    public void testFromBytesWhenInvalidJson() {
        Assert.assertThrows(SerializationException.class, () -> this.externalizer.fromJson(""));
    }

    @Test
    public void testFromBytes() {
        TopicOffset offset = new TopicOffset(new PartitionWithTopic("topic-1", 1), 1L, 2L);
        Assert.assertEquals((Object)offset, (Object)this.externalizer.fromBytes(this.externalizer.toBytes((Offset)offset)));
    }

    @Test
    public void testFromBytesWhenInvalidBytes() {
        Assert.assertThrows(SerializationException.class, () -> this.externalizer.fromBytes(new byte[]{0}));
    }
}

