/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.kafka.serializer;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import cz.o2.proxima.direct.kafka.serializer.ValueAsBytesSerializer;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.record.TimestampType;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.serialization.Serdes;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.storage.StreamElement;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class ValueAsBytesSerializerTest {
    Repository repo = Repository.ofTest((Config)ConfigFactory.load((String)"test-reference.conf").resolve(), (Repository.Validate[])new Repository.Validate[0]);
    EntityDescriptor event = this.repo.getEntity("event");
    EntityDescriptor gateway = this.repo.getEntity("gateway");
    long now = System.currentTimeMillis();

    @Test
    public void testDeserializer() {
        ValueAsBytesSerializer serializer = new ValueAsBytesSerializer("data");
        serializer.setup(this.event);
        StreamElement parsed = serializer.parseValue(this.event, "my-input-string".getBytes(StandardCharsets.UTF_8), 1, 2L, this.now);
        Assert.assertNotNull((Object)parsed);
        Assert.assertTrue((boolean)parsed.getParsed().isPresent());
        Assert.assertEquals((long)this.now, (long)parsed.getStamp());
    }

    @Test
    public void testDeserializerWithNullValue() {
        ValueAsBytesSerializer serializer = new ValueAsBytesSerializer("data");
        serializer.setup(this.event);
        StreamElement parsed = serializer.parseValue(this.event, null, 1, 2L, this.now);
        Assert.assertNotNull((Object)parsed);
        Assert.assertFalse((boolean)parsed.getParsed().isPresent());
        Assert.assertEquals((long)this.now, (long)parsed.getStamp());
        Assert.assertTrue((boolean)parsed.isDelete());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testWriteFails() {
        ValueAsBytesSerializer serializer = new ValueAsBytesSerializer("data");
        serializer.write("topic", 1, StreamElement.upsert((EntityDescriptor)this.event, (AttributeDescriptor)this.event.getAttribute("data"), (String)UUID.randomUUID().toString(), (String)"key", (String)"data", (long)this.now, (byte[])new byte[0]));
    }

    @Test
    public void testSerdes() {
        ValueAsBytesSerializer serializer = new ValueAsBytesSerializer("data");
        Assert.assertEquals(Serdes.ByteArray().getClass(), serializer.keySerde().getClass());
        Assert.assertEquals(Serdes.ByteArray().getClass(), serializer.valueSerde().getClass());
    }

    @Test
    public void testParseValue() {
        ValueAsBytesSerializer serializer = new ValueAsBytesSerializer("data");
        serializer.setup(this.event);
        ConsumerRecord record = new ConsumerRecord("topic", 1, 2L, this.now, TimestampType.CREATE_TIME, -1L, -1, -1, null, (Object)"my-input-string".getBytes(StandardCharsets.UTF_8));
        StreamElement parsed = serializer.read(record, this.event);
        Assert.assertNotNull((Object)parsed);
        Assert.assertTrue((boolean)parsed.getParsed().isPresent());
        Assert.assertEquals((long)this.now, (long)parsed.getStamp());
        Assert.assertEquals((Object)"data", (Object)parsed.getAttribute());
    }

    @Test
    public void testParseValueWildcard() {
        ValueAsBytesSerializer serializer = new ValueAsBytesSerializer("device.*");
        serializer.setup(this.gateway);
        ConsumerRecord record = new ConsumerRecord("topic", 1, 2L, this.now, TimestampType.CREATE_TIME, -1L, -1, -1, null, (Object)"my-input-string".getBytes(StandardCharsets.UTF_8));
        StreamElement parsed = serializer.read(record, this.event);
        Assert.assertNotNull((Object)parsed);
        Assert.assertTrue((boolean)parsed.getParsed().isPresent());
        Assert.assertEquals((long)this.now, (long)parsed.getStamp());
        Assert.assertEquals((Object)"device.1:2", (Object)parsed.getAttribute());
    }
}

