/*
 * Copyright 2017-2022 O2 Czech Republic, a.s.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cz.o2.proxima.direct.kafka;

import com.google.common.base.MoreObjects;
import cz.o2.proxima.direct.time.BoundedOutOfOrdernessWatermarkEstimator;
import cz.o2.proxima.direct.time.SkewedProcessingTimeIdlePolicy;
import cz.o2.proxima.direct.time.WatermarkConfiguration;
import cz.o2.proxima.time.WatermarkEstimatorFactory;
import cz.o2.proxima.time.WatermarkIdlePolicyFactory;
import java.util.Map;

public class KafkaWatermarkConfiguration extends WatermarkConfiguration {

  public KafkaWatermarkConfiguration(Map<String, Object> cfg) {
    super(cfg);
    configure();
  }

  @Override
  protected WatermarkIdlePolicyFactory getDefaultIdlePolicyFactory() {
    return new SkewedProcessingTimeIdlePolicy.Factory();
  }

  @Override
  protected WatermarkEstimatorFactory getDefaultEstimatorFactory() {
    return new BoundedOutOfOrdernessWatermarkEstimator.Factory();
  }

  @Override
  public String toString() {
    return MoreObjects.toStringHelper(this)
        .add("defaultIdlePolicyFactory", getDefaultIdlePolicyFactory())
        .add("defaultEstimatorFactory", getDefaultEstimatorFactory())
        .toString();
  }
}
