/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.blob;

import cz.o2.proxima.direct.bulk.FileFormat;
import cz.o2.proxima.direct.bulk.FileFormatUtils;
import cz.o2.proxima.direct.bulk.FileSystem;
import cz.o2.proxima.direct.bulk.NamingConvention;
import cz.o2.proxima.direct.core.DataAccessor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.storage.AbstractStorage;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public abstract class BlobStorageAccessor
extends AbstractStorage
implements DataAccessor {
    private static final long serialVersionUID = 1L;
    final Map<String, Object> cfg;

    public BlobStorageAccessor(EntityDescriptor entityDesc, URI uri, Map<String, Object> cfg) {
        super(entityDesc, uri);
        this.cfg = Collections.unmodifiableMap(cfg);
    }

    public abstract FileSystem getTargetFileSystem();

    FileFormat getFileFormat() {
        return FileFormatUtils.getFileFormat("", this.getCfg());
    }

    public NamingConvention getNamingConvention() {
        return FileFormatUtils.getNamingConvention("", this.getCfg(), this.getRollPeriod(), this.getFileFormat());
    }

    public File getTmpDir() {
        File parent = Optional.ofNullable(this.cfg.get("tmp.dir")).map(Object::toString).map(File::new).orElse(new File(System.getProperty("java.io.tmpdir")));
        return new File(parent, "blob-local-storage-" + UUID.randomUUID());
    }

    public long getRollPeriod() {
        return Optional.ofNullable(this.cfg.get("log-roll-interval")).map(Object::toString).map(Long::valueOf).orElse(3600000L);
    }

    public long getAllowedLateness() {
        return Optional.ofNullable(this.cfg.get("allowed-lateness-ms")).map(Object::toString).map(Long::valueOf).orElse(300000L);
    }

    public long getPartitionMinSize() {
        return Optional.ofNullable(this.cfg.get("partition.size")).map(Object::toString).map(Long::valueOf).orElse(0x6400000L);
    }

    public int getPartitionMaxNumBlobs() {
        return Optional.ofNullable(this.cfg.get("partition.max-blobs")).map(Object::toString).map(Integer::valueOf).orElse(1000);
    }

    public Map<String, Object> getCfg() {
        return this.cfg;
    }
}

