/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.blob;

import cz.o2.proxima.direct.blob.BlobBase;
import cz.o2.proxima.direct.blob.BlobPath;
import cz.o2.proxima.direct.blob.BlobStorageAccessor;
import cz.o2.proxima.direct.bulk.AbstractBulkFileSystemAttributeWriter;
import cz.o2.proxima.direct.bulk.FileSystem;
import cz.o2.proxima.direct.bulk.Path;
import cz.o2.proxima.direct.core.AttributeWriterBase;
import cz.o2.proxima.direct.core.BulkAttributeWriter;
import cz.o2.proxima.direct.core.CommitCallback;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.internal.shaded.com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.internal.shaded.com.google.common.io.ByteStreams;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.storage.StreamElement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BulkBlobWriter<BlobT extends BlobBase, AccessorT extends BlobStorageAccessor>
implements BulkAttributeWriter {
    private static final Logger log = LoggerFactory.getLogger(BulkBlobWriter.class);
    private final AccessorT accessor;
    private final Context context;
    @Nullable
    private transient BulkAttributeWriter wrap;
    private transient boolean initialized;
    private transient File tmpDir;

    public BulkBlobWriter(AccessorT accessor, Context context) {
        this.accessor = accessor;
        this.context = context;
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.accessor.getEntityDescriptor();
    }

    public URI getUri() {
        return this.accessor.getUri();
    }

    public void write(StreamElement data, long watermark, CommitCallback statusCallback) {
        this.init();
        this.wrap.write(data, watermark, statusCallback);
    }

    public void updateWatermark(long watermark) {
        Optional.ofNullable(this.wrap).ifPresent(w -> w.updateWatermark(watermark));
    }

    public void rollback() {
        Optional.ofNullable(this.wrap).ifPresent(AttributeWriterBase::rollback);
    }

    private void init() {
        if (!this.initialized) {
            this.tmpDir = ((BlobStorageAccessor)((Object)this.accessor)).getTmpDir();
            FileSystem localFs = FileSystem.local(this.tmpDir, ((BlobStorageAccessor)((Object)this.accessor)).getNamingConvention());
            this.wrap = new AbstractBulkFileSystemAttributeWriter(this.getEntityDescriptor(), this.accessor.getUri(), localFs, ((BlobStorageAccessor)((Object)this.accessor)).getNamingConvention(), ((BlobStorageAccessor)((Object)this.accessor)).getFileFormat(), this.context, ((BlobStorageAccessor)((Object)this.accessor)).getRollPeriod(), ((BlobStorageAccessor)((Object)this.accessor)).getAllowedLateness()){

                @Override
                protected void flush(AbstractBulkFileSystemAttributeWriter.Bulk bulk) {
                    BulkBlobWriter.this.flush(bulk.getPath(), bulk.getMaxTs());
                }
            };
            if (!this.tmpDir.exists()) {
                this.tmpDir.mkdirs();
            } else if (this.tmpDir.isDirectory()) {
                this.removeDir(this.tmpDir);
                this.tmpDir.mkdirs();
            } else {
                throw new IllegalStateException("Temporary directory " + this.tmpDir + " is not directory");
            }
            this.initialized = true;
        }
    }

    private void removeDir(File dir) {
        Preconditions.checkArgument((boolean)dir.isDirectory());
        if (dir.exists()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (f.isDirectory()) {
                        this.removeDir(f);
                    }
                    Preconditions.checkState((boolean)f.delete());
                }
            }
            Preconditions.checkState((boolean)dir.delete());
        }
    }

    @VisibleForTesting
    void flush() {
        this.updateWatermark(Long.MAX_VALUE);
    }

    private void flush(Path file, long bucketEndStamp) {
        BlobPath targetPath = (BlobPath)((BlobStorageAccessor)((Object)this.accessor)).getTargetFileSystem().newPath(bucketEndStamp - 1L);
        try (InputStream in = file.reader();
             OutputStream out = targetPath.writer();){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
            out.close();
            this.deleteHandlingErrors(file);
        }
        catch (Exception ex) {
            log.warn("Error while putting object {} to {}", file, targetPath, ex);
            this.deleteBlobIfExists(targetPath.getBlob());
            throw new IllegalStateException(ex);
        }
        log.info("Flushed source path {} to {}", (Object)file, (Object)targetPath);
    }

    protected abstract void deleteBlobIfExists(BlobT var1);

    private void deleteHandlingErrors(Path f) {
        try {
            f.delete();
        }
        catch (IOException ex) {
            log.warn("Failed to delete {}. Ignoring", (Object)f, (Object)ex);
        }
    }

    public void close() {
        Optional.ofNullable(this.wrap).ifPresent(AttributeWriterBase::close);
        if (this.tmpDir.exists() && this.tmpDir.isDirectory()) {
            try {
                this.removeDir(this.tmpDir);
            }
            catch (Exception ex) {
                log.error("Failed to remove directory {}. Ignored.", (Object)this.tmpDir, (Object)ex);
            }
        }
    }

    @VisibleForTesting
    String toBlobName(long ts) {
        return ((BlobStorageAccessor)((Object)this.accessor)).getNamingConvention().nameOf(ts);
    }

    public AccessorT getAccessor() {
        return this.accessor;
    }

    public Context getContext() {
        return this.context;
    }

    boolean isInitialized() {
        return this.initialized;
    }
}

