/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.blob;

import cz.o2.proxima.functional.Factory;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.util.ExceptionUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryStrategy
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RetryStrategy.class);
    private final int initialRetryDelay;
    private final int maxRetryDelay;
    private final Set<Class<? extends Exception>> retryableException = new HashSet<Class<? extends Exception>>();

    public RetryStrategy(int initialRetryDelay, int maxRetryDelay) {
        Preconditions.checkArgument((initialRetryDelay < maxRetryDelay / 2 ? 1 : 0) != 0, (String)"Max retry delay must be at least double of initial delay, got %s and %s", (int)initialRetryDelay, (int)maxRetryDelay);
        this.initialRetryDelay = initialRetryDelay;
        this.maxRetryDelay = maxRetryDelay;
    }

    public RetryStrategy withRetryableException(Class<? extends Exception> ex) {
        this.retryableException.add(ex);
        return this;
    }

    public void retry(Runnable what) {
        this.retry((Factory & Serializable)() -> {
            what.run();
            return null;
        });
    }

    public <T> T retry(Factory<T> what) {
        int delay = this.initialRetryDelay;
        while (true) {
            try {
                return (T)what.apply();
            }
            catch (Exception ex) {
                boolean shouldRetry;
                boolean rethrow = true;
                if (!this.retryableException.contains(ex.getClass())) continue;
                boolean bl = shouldRetry = delay <= this.maxRetryDelay;
                if (!shouldRetry) continue;
                log.warn("Exception while communicating with cloud storage. Retrying after {} ms", (Object)delay, (Object)ex);
                long effectiveDelay = delay;
                ExceptionUtils.unchecked((ExceptionUtils.ThrowingRunnable & Serializable)() -> TimeUnit.MILLISECONDS.sleep(effectiveDelay));
                delay *= 2;
                rethrow = false;
                if (!rethrow) continue;
                throw ex;
            }
            break;
        }
    }
}

