/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.bulk;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import cz.o2.proxima.direct.bulk.FileFormat;
import cz.o2.proxima.direct.bulk.Path;
import cz.o2.proxima.direct.bulk.Reader;
import cz.o2.proxima.direct.bulk.Writer;
import cz.o2.proxima.direct.bulk.com.google.protobuf.ByteString;
import cz.o2.proxima.direct.bulk.com.google.protobuf.Parser;
import cz.o2.proxima.gcloud.storage.proto.Serialization;
import cz.o2.proxima.internal.shaded.com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.internal.shaded.com.google.common.collect.AbstractIterator;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.util.ExceptionUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BinaryBlobFormat
implements FileFormat {
    private static final Logger log = LoggerFactory.getLogger(BinaryBlobFormat.class);
    private static final long serialVersionUID = 1L;
    private static final String MAGIC = "gs::proxima";
    private static final String MAGIC_V1 = "proxima:bulk:v1";
    private final boolean writeGzip;

    BinaryBlobFormat(boolean writeGzip) {
        this.writeGzip = writeGzip;
    }

    @Override
    public BinaryBlobWriter openWriter(Path path, EntityDescriptor entity) throws IOException {
        return new BinaryBlobWriter(path, this.writeGzip, path.writer());
    }

    @Override
    public String fileSuffix() {
        return this.writeGzip ? "blob.gz" : "blob";
    }

    @Override
    public BinaryBlobReader openReader(Path path, EntityDescriptor entity) throws IOException {
        return new BinaryBlobReader(path, entity, path.reader());
    }

    public static class DumpTool {
        private static void usage() {
            System.err.println("Usage: DumpTool <entity name>");
            System.err.println("Reads binary blob from stdin and dumps to stdout");
            System.exit(1);
        }

        public static void main(String[] args) throws IOException {
            if (args.length != 1) {
                DumpTool.usage();
            }
            Repository repo = Repository.of((Config)ConfigFactory.load().resolve());
            EntityDescriptor entity = (EntityDescriptor)repo.findEntity(args[0]).orElseThrow(() -> new IllegalArgumentException("Cannot find entity " + args[0]));
            BinaryBlobFormat format = new BinaryBlobFormat(true);
            Path stdin = Path.stdin(format);
            try (BinaryBlobReader reader = format.openReader(stdin, entity);){
                reader.forEach(e -> System.out.println(e.dump()));
            }
        }
    }

    public static class BinaryBlobReader
    implements Reader {
        private final Path path;
        private final Parser<Serialization.Element> parser = Serialization.Element.parser();
        private final EntityDescriptor entity;
        private final Serialization.Header header;
        private final String blobName;
        private DataInputStream blobStream = null;

        @VisibleForTesting
        BinaryBlobReader(Path path, EntityDescriptor entity, InputStream in) throws IOException {
            this.path = path;
            this.entity = entity;
            this.blobName = path.toString();
            this.header = this.readHeader(this.blobName, in);
            this.blobStream = this.toInputStream(in);
        }

        @Override
        public Iterator<StreamElement> iterator() {
            return new AbstractIterator<StreamElement>(){

                protected StreamElement computeNext() {
                    StreamElement next;
                    try {
                        next = this.next();
                    }
                    catch (EOFException eof) {
                        log.debug("EOF while reading {}. Terminating iteration.", (Object)blobName, (Object)eof);
                        next = null;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                    if (next != null) {
                        return next;
                    }
                    this.endOfData();
                    return null;
                }
            };
        }

        private byte[] readBytes(DataInputStream in) throws IOException {
            byte[] buf = new byte[in.readInt()];
            in.readFully(buf);
            return buf;
        }

        private Serialization.Header readHeader(String blobName, InputStream in) throws IOException {
            try {
                DataInputStream dos = new DataInputStream(in);
                Serialization.Header parsed = Serialization.Header.parseFrom(this.readBytes(dos));
                String magic = parsed.getMagic();
                if (!BinaryBlobFormat.MAGIC.equals(magic) && !BinaryBlobFormat.MAGIC_V1.equals(magic)) {
                    throw new IllegalArgumentException(String.format("Magic not matching, exptected [%s] or [%s], got [%s]", BinaryBlobFormat.MAGIC, BinaryBlobFormat.MAGIC_V1, parsed.getMagic()));
                }
                return parsed;
            }
            catch (EOFException eof) {
                log.warn("EOF while reading input of {}. Probably corrupt input?", (Object)blobName, (Object)eof);
                return Serialization.Header.getDefaultInstance();
            }
        }

        private StreamElement next() throws IOException {
            try {
                return this.fromBytes(this.readBytes(this.blobStream));
            }
            catch (EOFException eof) {
                log.trace("EOF while reading next data from blob {}.", (Object)this.blobName, (Object)eof);
                return null;
            }
        }

        private DataInputStream toInputStream(InputStream in) throws IOException {
            if (this.header.getGzip()) {
                return new DataInputStream(new GZIPInputStream(in));
            }
            return new DataInputStream(in);
        }

        private StreamElement fromBytes(byte[] data) throws IOException {
            Serialization.Element parsed = this.parser.parseFrom(data);
            if (parsed.getDelete()) {
                if (parsed.getDeleteWildcard()) {
                    return StreamElement.deleteWildcard((EntityDescriptor)this.entity, this.getAttr(parsed), (String)parsed.getUuid(), (String)parsed.getKey(), (String)parsed.getAttribute(), (long)parsed.getStamp());
                }
                return StreamElement.delete((EntityDescriptor)this.entity, this.getAttr(parsed), (String)parsed.getUuid(), (String)parsed.getKey(), (String)parsed.getAttribute(), (long)parsed.getStamp());
            }
            return StreamElement.upsert((EntityDescriptor)this.entity, this.getAttr(parsed), (String)parsed.getUuid(), (String)parsed.getKey(), (String)parsed.getAttribute(), (long)parsed.getStamp(), (byte[])parsed.getValue().toByteArray());
        }

        private AttributeDescriptor<?> getAttr(Serialization.Element parsed) {
            return (AttributeDescriptor)this.entity.findAttribute(parsed.getAttribute(), true).orElseThrow(() -> new IllegalArgumentException("Unknown attribute " + parsed.getAttribute()));
        }

        @Override
        public void close() {
            if (this.blobStream != null) {
                ExceptionUtils.unchecked(this.blobStream::close);
                this.blobStream = null;
            }
        }

        @Override
        public Path getPath() {
            return this.path;
        }
    }

    public static class BinaryBlobWriter
    implements Writer {
        private final Path path;
        private final boolean gzip;
        private DataOutputStream blobStream = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        BinaryBlobWriter(Path path, boolean gzip, OutputStream out) throws IOException {
            this.path = path;
            this.gzip = gzip;
            try {
                this.writeHeader(out);
                this.blobStream = this.toOutputStream(out);
            }
            finally {
                if (this.blobStream == null && out != null) {
                    out.close();
                }
            }
        }

        private void writeBytes(DataOutputStream out, byte[] bytes) throws IOException {
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        private void writeHeader(OutputStream out) throws IOException {
            DataOutputStream dos = new DataOutputStream(out);
            byte[] header = Serialization.Header.newBuilder().setMagic(BinaryBlobFormat.MAGIC_V1).setVersion(1).setGzip(this.gzip).build().toByteArray();
            this.writeBytes(dos, header);
            dos.flush();
        }

        @Override
        public void write(StreamElement elem) throws IOException {
            this.writeBytes(this.blobStream, this.toBytes(elem));
        }

        private DataOutputStream toOutputStream(OutputStream out) throws IOException {
            if (this.gzip) {
                return new DataOutputStream(new GZIPOutputStream(out));
            }
            return new DataOutputStream(out);
        }

        private byte[] toBytes(StreamElement data) {
            return Serialization.Element.newBuilder().setKey(data.getKey()).setUuid(data.getUuid()).setAttribute(data.getAttribute()).setDelete(data.isDelete()).setDeleteWildcard(data.isDeleteWildcard()).setStamp(data.getStamp()).setValue(data.getValue() == null ? ByteString.EMPTY : ByteString.copyFrom(data.getValue())).build().toByteArray();
        }

        @Override
        public void close() throws IOException {
            if (this.blobStream != null) {
                this.blobStream.close();
                this.blobStream = null;
            }
        }

        @Override
        public Path getPath() {
            return this.path;
        }
    }
}

