/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.bulk;

import cz.o2.proxima.direct.bulk.NamingConvention;
import cz.o2.proxima.functional.Factory;
import cz.o2.proxima.internal.shaded.com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.util.Pair;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNamingConvention
implements NamingConvention {
    private static final Logger log = LoggerFactory.getLogger(DefaultNamingConvention.class);
    private static final long serialVersionUID = 1L;
    private static final char SEPARATOR = '/';
    private static final Pattern NAME_PATTERN = Pattern.compile(".*/?[^/]+-([0-9]+)_([0-9]+)[^/]*\\.+[^/]*$");
    private static final DateTimeFormatter DIR_FORMAT = DateTimeFormatter.ofPattern("yyyy/MM/");
    private final long rollPeriodMs;
    private final String prefix;
    private final String suffix;
    private final Factory<String> uuidGenerator;

    DefaultNamingConvention(Duration rollPeriod, String prefix, String suffix) {
        this(rollPeriod, prefix, suffix, (Factory<String>)(Factory & Serializable)() -> UUID.randomUUID().toString());
    }

    @VisibleForTesting
    public DefaultNamingConvention(Duration rollPeriod, String prefix, String suffix, Factory<String> uuidGenerator) {
        this.rollPeriodMs = rollPeriod.toMillis();
        this.prefix = prefix;
        this.suffix = suffix;
        this.uuidGenerator = uuidGenerator;
    }

    @Override
    public String nameOf(long ts) {
        long boundary = ts - ts % this.rollPeriodMs;
        String date = DIR_FORMAT.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(boundary), ZoneId.ofOffset("UTC", ZoneOffset.UTC)));
        return String.format("/%s%s-%d_%d_%s.%s", date, this.prefix, boundary, boundary + this.rollPeriodMs, this.uuidGenerator.apply(), this.suffix);
    }

    public Set<String> prefixesOf(long startStamp, long endStamp) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy/MM");
        TreeSet<String> prefixes = new TreeSet<String>();
        long t = startStamp;
        if (startStamp > Long.MIN_VALUE && endStamp < Long.MAX_VALUE) {
            LocalDateTime time = LocalDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.ofOffset("UTC", ZoneOffset.UTC));
            LocalDateTime end = LocalDateTime.ofInstant(Instant.ofEpochMilli(endStamp), ZoneId.ofOffset("UTC", ZoneOffset.UTC));
            while (time.isBefore(end)) {
                prefixes.add('/' + format.format(time));
                time = time.plusMonths(1L);
            }
            prefixes.add('/' + format.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(endStamp), ZoneId.ofOffset("UTC", ZoneOffset.UTC))));
        } else {
            prefixes.add(String.valueOf('/'));
        }
        log.debug("Prefixes of stamp range {}-{} are {}", startStamp, endStamp, prefixes);
        return prefixes;
    }

    @Override
    public boolean isInRange(String name, long minTs, long maxTs) {
        Matcher matcher = NAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            long min = Long.parseLong(matcher.group(1));
            long max = Long.parseLong(matcher.group(2));
            return min < maxTs && max > minTs;
        }
        log.warn("Skipping unparseable name {}", (Object)name);
        return false;
    }

    @Override
    public Pair<Long, Long> parseMinMaxTimestamp(String name) {
        Matcher matcher = NAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            long min = Long.parseLong(matcher.group(1));
            long max = Long.parseLong(matcher.group(2));
            return Pair.of((Object)min, (Object)max);
        }
        throw new IllegalArgumentException("Name " + name + " is not understood by this convetion.");
    }
}

