/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.bulk;

import cz.o2.proxima.direct.bulk.NamingConvention;
import cz.o2.proxima.direct.bulk.Path;
import cz.o2.proxima.util.ExceptionUtils;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.stream.Stream;

public interface FileSystem
extends Serializable {
    public static FileSystem local(final File parent, final NamingConvention convention) {
        return new FileSystem(){
            private static final long serialVersionUID = 1L;

            @Override
            public URI getUri() {
                return URI.create("file://" + parent.getAbsolutePath());
            }

            @Override
            public Stream<Path> list(long minTs, long maxTs) {
                return this.listRecursive(parent).filter(f -> convention.isInRange(f.getAbsolutePath(), minTs, maxTs)).map(p -> Path.local(this, p));
            }

            private Stream<File> listRecursive(File file) {
                ArrayList<Stream<File>> parts = new ArrayList<Stream<File>>();
                if (file.isDirectory()) {
                    for (File f : file.listFiles()) {
                        parts.add(this.listRecursive(f));
                    }
                    return parts.stream().reduce(Stream.empty(), Stream::concat);
                }
                return Stream.of(file);
            }

            @Override
            public Path newPath(long ts) {
                String name = convention.nameOf(ts);
                return (Path)ExceptionUtils.uncheckedFactory((ExceptionUtils.ThrowingFactory & Serializable)() -> Path.local(this, new File(parent, name)));
            }
        };
    }

    public URI getUri();

    public Stream<Path> list(long var1, long var3);

    public Path newPath(long var1);

    default public Stream<Path> list() {
        return this.list(Long.MIN_VALUE, Long.MAX_VALUE);
    }
}

