/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.bulk;

import cz.o2.proxima.direct.bulk.FileFormat;
import cz.o2.proxima.direct.bulk.Path;
import cz.o2.proxima.direct.bulk.Reader;
import cz.o2.proxima.direct.bulk.Writer;
import cz.o2.proxima.direct.bulk.com.google.protobuf.Message;
import cz.o2.proxima.direct.bulk.com.google.protobuf.util.JsonFormat;
import cz.o2.proxima.gcloud.storage.proto.Serialization;
import cz.o2.proxima.internal.shaded.com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.internal.shaded.com.google.common.collect.AbstractIterator;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.scheme.ValueSerializer;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.util.ExceptionUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFormat
implements FileFormat {
    private static final Logger log = LoggerFactory.getLogger(JsonFormat.class);
    private static final long serialVersionUID = 1L;
    private static JsonFormat.Parser parser = cz.o2.proxima.direct.bulk.com.google.protobuf.util.JsonFormat.parser();
    private static JsonFormat.Printer printer = cz.o2.proxima.direct.bulk.com.google.protobuf.util.JsonFormat.printer();
    private final boolean gzip;

    JsonFormat(boolean gzip) {
        this.gzip = gzip;
    }

    @Override
    public Reader openReader(Path path, EntityDescriptor entity) throws IOException {
        return new JsonReader(entity, path, this.gzip);
    }

    @Override
    public Writer openWriter(Path path, EntityDescriptor entity) throws IOException {
        return new JsonWriter(path, this.gzip);
    }

    @Override
    public String fileSuffix() {
        return this.gzip ? "json.gz" : "json";
    }

    @VisibleForTesting
    static StreamElement toStreamElement(Serialization.JsonElement element, EntityDescriptor entity) {
        AttributeDescriptor attr = entity.getAttribute(element.getAttribute());
        if (element.getDeleteWildcard()) {
            Preconditions.checkArgument((boolean)attr.isWildcard(), (String)"Attribute [%s] is not wildcard attribute", (Object)element.getAttribute());
            return StreamElement.deleteWildcard((EntityDescriptor)entity, (AttributeDescriptor)attr, (String)element.getUuid(), (String)element.getKey(), (long)element.getStamp());
        }
        if (element.getDelete()) {
            return StreamElement.delete((EntityDescriptor)entity, (AttributeDescriptor)attr, (String)element.getUuid(), (String)element.getKey(), (String)element.getAttribute(), (long)element.getStamp());
        }
        return StreamElement.upsert((EntityDescriptor)entity, (AttributeDescriptor)attr, (String)element.getUuid(), (String)element.getKey(), (String)element.getAttribute(), (long)element.getStamp(), (byte[])attr.getValueSerializer().serialize(attr.getValueSerializer().fromJsonValue(element.getValue())));
    }

    @VisibleForTesting
    static Serialization.JsonElement toJsonElement(StreamElement element) {
        ValueSerializer serializer = element.getAttributeDescriptor().getValueSerializer();
        Serialization.JsonElement.Builder builder = Serialization.JsonElement.newBuilder().setAttribute(element.getAttribute()).setUuid(element.getUuid()).setStamp(element.getStamp()).setKey(element.getKey());
        if (element.isDeleteWildcard()) {
            return builder.setDeleteWildcard(true).setDelete(true).build();
        }
        if (element.isDelete()) {
            return builder.setDelete(true).build();
        }
        Optional maybeValue = element.getParsed();
        Preconditions.checkArgument((boolean)maybeValue.isPresent(), (String)"Cannot deserialize value in [%s]", (Object)element);
        return builder.setValue(serializer.asJsonValue(maybeValue.get())).build();
    }

    private static class JsonWriter
    implements Writer {
        private final Path path;
        private final boolean gzip;
        private BufferedWriter writer;

        JsonWriter(Path path, boolean gzip) {
            this.path = path;
            this.gzip = gzip;
        }

        @Override
        public void write(StreamElement elem) throws IOException {
            if (this.writer == null) {
                OutputStream out = this.path.writer();
                if (this.gzip) {
                    out = new GZIPOutputStream(out);
                }
                this.writer = new BufferedWriter(new OutputStreamWriter(out));
            }
            this.writer.write(printer.print(JsonFormat.toJsonElement(elem)).replace('\n', ' '));
            this.writer.write(10);
            log.debug("Written element {} into json at {}", (Object)elem, (Object)this.path);
        }

        @Override
        public void close() throws IOException {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }

        @Override
        public Path getPath() {
            return this.path;
        }
    }

    private static class JsonReader
    extends AbstractIterator<StreamElement>
    implements Reader {
        private final EntityDescriptor entity;
        private final Path path;
        private final boolean gzip;
        private BufferedReader input;

        JsonReader(EntityDescriptor entity, Path path, boolean gzip) {
            this.entity = entity;
            this.path = path;
            this.gzip = gzip;
        }

        @Override
        public void close() {
            if (this.input != null) {
                ExceptionUtils.unchecked((ExceptionUtils.ThrowingRunnable & Serializable)() -> this.input.close());
                this.input = null;
            }
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        protected StreamElement computeNext() {
            if (this.input == null) {
                InputStream raw;
                InputStream inputStream = raw = (InputStream)ExceptionUtils.uncheckedFactory(this.path::reader);
                if (this.gzip) {
                    inputStream = (InputStream)ExceptionUtils.uncheckedFactory((ExceptionUtils.ThrowingFactory & Serializable)() -> new GZIPInputStream(raw));
                }
                this.input = new BufferedReader(new InputStreamReader(inputStream));
            }
            try {
                String line = this.input.readLine();
                if (line != null) {
                    Serialization.JsonElement.Builder builder = Serialization.JsonElement.newBuilder();
                    parser.merge(line, (Message.Builder)builder);
                    return JsonFormat.toStreamElement(builder.build(), this.entity);
                }
            }
            catch (EOFException line) {
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return (StreamElement)this.endOfData();
        }

        @Override
        public Iterator<StreamElement> iterator() {
            this.close();
            return this;
        }
    }
}

