/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.bulk;

import cz.o2.proxima.direct.bulk.FileFormat;
import cz.o2.proxima.direct.bulk.FileSystem;
import cz.o2.proxima.direct.bulk.NamingConvention;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Duration;

public interface Path
extends Serializable {
    public static Path local(final FileSystem fs, final File path) {
        return new Path(){
            private static final long serialVersionUID = 1L;

            @Override
            public InputStream reader() throws IOException {
                return new FileInputStream(path);
            }

            @Override
            public OutputStream writer() throws IOException {
                if (!path.getParentFile().exists() && !path.getParentFile().mkdirs()) {
                    throw new IOException("Failed to create dir " + path.getParentFile());
                }
                return new FileOutputStream(path);
            }

            @Override
            public FileSystem getFileSystem() {
                return fs;
            }

            @Override
            public void delete() throws IOException {
                if (path.exists() && !path.delete()) {
                    throw new IOException("Failed to delete " + path);
                }
            }

            public String toString() {
                return path.getAbsolutePath();
            }
        };
    }

    public static Path stdin(final FileFormat format) {
        return new Path(){
            private static final long serialVersionUID = 1L;

            @Override
            public InputStream reader() throws IOException {
                return System.in;
            }

            @Override
            public OutputStream writer() {
                throw new UnsupportedOperationException("Can only read from stdin.");
            }

            @Override
            public FileSystem getFileSystem() {
                return FileSystem.local(new File("/dev/stdin"), NamingConvention.defaultConvention(Duration.ofHours(1L), "prefix", format.fileSuffix()));
            }

            @Override
            public void delete() throws IOException {
                throw new UnsupportedOperationException("Cannot delete stdin.");
            }
        };
    }

    public InputStream reader() throws IOException;

    public OutputStream writer() throws IOException;

    public FileSystem getFileSystem();

    public void delete() throws IOException;
}

