/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.s3;

import cz.o2.proxima.direct.batch.BatchLogObservable;
import cz.o2.proxima.direct.blob.BlobStorageAccessor;
import cz.o2.proxima.direct.bulk.FileSystem;
import cz.o2.proxima.direct.core.AttributeWriterBase;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.s3.BulkS3Writer;
import cz.o2.proxima.direct.s3.S3FileSystem;
import cz.o2.proxima.direct.s3.S3LogObservable;
import cz.o2.proxima.repository.EntityDescriptor;
import java.net.URI;
import java.util.Map;
import java.util.Optional;

class S3Accessor
extends BlobStorageAccessor {
    private static final long serialVersionUID = 1L;
    private S3FileSystem fs;

    public S3Accessor(EntityDescriptor entityDesc, URI uri, Map<String, Object> cfg) {
        super(entityDesc, uri, cfg);
    }

    @Override
    public FileSystem getTargetFileSystem() {
        return this.fs;
    }

    public Optional<AttributeWriterBase> getWriter(Context context) {
        this.fs = this.initFs(context);
        return Optional.of(new BulkS3Writer(this, context));
    }

    public Optional<BatchLogObservable> getBatchLogObservable(Context context) {
        this.fs = this.initFs(context);
        return Optional.of(new S3LogObservable(this, context));
    }

    S3FileSystem initFs(Context context) {
        if (this.fs == null) {
            return new S3FileSystem(this, context);
        }
        return this.fs;
    }
}

