/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.s3;

import com.amazonaws.services.s3.model.S3Object;
import com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.direct.blob.BlobBase;
import cz.o2.proxima.direct.blob.BlobPath;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.s3.S3Client;
import cz.o2.proxima.direct.s3.S3FileSystem;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BlobPath
extends BlobPath<S3Blob> {
    private static final Logger log = LoggerFactory.getLogger(S3BlobPath.class);
    private static final long serialVersionUID = 1L;
    private final Context context;

    public static S3BlobPath of(Context context, S3FileSystem fs, String name) {
        return new S3BlobPath(context, fs, new S3Blob(name, fs));
    }

    @VisibleForTesting
    S3BlobPath(Context context, S3FileSystem fs, S3Blob blob) {
        super(fs, blob);
        this.context = Objects.requireNonNull(context);
    }

    @Override
    public InputStream reader() {
        return ((S3FileSystem)this.getFileSystem()).getObject(((S3Blob)this.getBlob()).getName()).getObjectContent();
    }

    @Override
    public OutputStream writer() {
        return ((S3Client)((Object)this.getFileSystem())).putObject(this.getBlobName());
    }

    @Override
    public void delete() {
        ((S3Client)((Object)this.getFileSystem())).deleteObject(((S3Blob)this.getBlob()).getName());
    }

    @Override
    public String toString() {
        return "S3BlobPath(context=" + this.context + ")";
    }

    public static class S3Blob
    implements BlobBase {
        private final String name;
        private final S3FileSystem fs;

        @VisibleForTesting
        S3Blob(String name, S3FileSystem fs) {
            this.name = Objects.requireNonNull(name);
            this.fs = fs;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long getSize() {
            try (S3Object object = this.fs.getObject(this.name);){
                long l = object.getObjectMetadata().getContentLength();
                return l;
            }
            catch (Exception e) {
                log.warn("Unable to retrieve object size of [{}] from [{}].", this.name, this.fs.getUri(), e);
                return 0L;
            }
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

