/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import cz.o2.proxima.direct.blob.RetryStrategy;
import cz.o2.proxima.functional.BiConsumer;
import cz.o2.proxima.functional.UnaryFunction;
import cz.o2.proxima.storage.UriUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class S3Client
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(S3Client.class);
    private static final long serialVersionUID = 1L;
    private static final int UPLOAD_PART_SIZE = 0x500000;
    private final String bucket;
    private final String path;
    private final RetryStrategy retry;
    private final Map<String, Object> cfg;
    @Nullable
    private transient AmazonS3 client;

    S3Client(URI uri, Map<String, Object> cfg) {
        this.bucket = uri.getAuthority();
        this.path = S3Client.toPath(uri);
        int initialRetryDelay = S3Client.getOpt(cfg, "initial-retry-delay-ms", Integer::valueOf, 5000);
        int maxRetryDelay = S3Client.getOpt(cfg, "max-retry-delay-ms", Integer::valueOf, 10240000);
        this.retry = new RetryStrategy(initialRetryDelay, maxRetryDelay);
        this.cfg = cfg;
        new AmazonS3Factory(cfg).validate();
    }

    private static String toPath(URI uri) {
        return UriUtil.getPathNormalized((URI)uri) + "/";
    }

    static <T> T getOpt(Map<String, Object> cfg, String name, UnaryFunction<String, T> map, T defval) {
        return (T)Optional.ofNullable(cfg.get(name)).map(Object::toString).map(arg_0 -> map.apply(arg_0)).orElse(defval);
    }

    @VisibleForTesting
    AmazonS3 client() {
        if (this.client == null) {
            this.client = new AmazonS3Factory(this.cfg).build();
        }
        return this.client;
    }

    public S3Object getObject(String blobName) {
        return this.client().getObject(this.getBucket(), blobName);
    }

    public void deleteObject(String key) {
        this.client().deleteObject(this.getBucket(), key);
    }

    public OutputStream putObject(final String blobName) {
        Preconditions.checkState((!this.client().doesObjectExist(this.bucket, blobName) ? 1 : 0) != 0, (Object)"Object already exists.");
        final String currentBucket = this.getBucket();
        final String uploadId = this.client().initiateMultipartUpload(new InitiateMultipartUploadRequest(currentBucket, blobName)).getUploadId();
        final ArrayList eTags = new ArrayList();
        final byte[] partBuffer = new byte[0x500000];
        return new OutputStream(){
            private boolean closed = false;
            private int currentBytes = 0;
            private int partNumber = 1;

            @Override
            public void write(int b) throws IOException {
                Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Output stream already closed.");
                partBuffer[this.currentBytes] = (byte)b;
                ++this.currentBytes;
                if (this.currentBytes >= 0x500000) {
                    this.flush();
                }
            }

            @Override
            public void flush() throws IOException {
                Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Output stream already closed.");
                if (this.currentBytes > 0) {
                    try (ByteArrayInputStream is = new ByteArrayInputStream(partBuffer, 0, this.currentBytes);){
                        UploadPartRequest uploadPartRequest = new UploadPartRequest().withBucketName(currentBucket).withKey(blobName).withUploadId(uploadId).withPartNumber(this.partNumber).withInputStream(is).withPartSize(this.currentBytes);
                        UploadPartResult uploadPartResult = S3Client.this.client().uploadPart(uploadPartRequest);
                        eTags.add(uploadPartResult.getPartETag());
                        ++this.partNumber;
                    }
                }
                this.currentBytes = 0;
            }

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    this.flush();
                    S3Client.this.client().completeMultipartUpload(new CompleteMultipartUploadRequest(currentBucket, blobName, uploadId, eTags));
                    this.closed = true;
                }
            }
        };
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getPath() {
        return this.path;
    }

    public RetryStrategy getRetry() {
        return this.retry;
    }

    @Nullable
    public AmazonS3 getClient() {
        return this.client;
    }

    @VisibleForTesting
    static class AmazonS3Factory {
        private static final Map<String, BiConsumer<Object, AmazonS3ClientBuilder>> UPDATERS = new HashMap<String, BiConsumer<Object, AmazonS3ClientBuilder>>();
        private final Map<String, Object> cfg;

        private static ClientConfiguration clientConfiguration(AmazonS3ClientBuilder builder) {
            return Optional.ofNullable(builder.getClientConfiguration()).orElse(new ClientConfiguration());
        }

        static AwsClientBuilder.EndpointConfiguration endpoint(AmazonS3ClientBuilder builder) {
            return Optional.ofNullable(builder.getEndpoint()).orElse(new AwsClientBuilder.EndpointConfiguration("", ""));
        }

        AmazonS3Factory(Map<String, Object> cfg) {
            this.cfg = cfg;
        }

        AmazonS3 build() {
            this.validate();
            AmazonS3ClientBuilder builder = AmazonS3Client.builder();
            UPDATERS.forEach((name, updater) -> Optional.ofNullable(this.cfg.get(name)).ifPresent(value -> updater.accept(value, (Object)builder)));
            final String accessKey = S3Client.getOpt(this.cfg, "access-key", Object::toString, "");
            final String secretKey = S3Client.getOpt(this.cfg, "secret-key", Object::toString, "");
            builder.setCredentials(new AWSCredentialsProvider(){

                @Override
                public AWSCredentials getCredentials() {
                    return new AWSCredentials(){

                        @Override
                        public String getAWSAccessKeyId() {
                            return accessKey;
                        }

                        @Override
                        public String getAWSSecretKey() {
                            return secretKey;
                        }
                    };
                }

                @Override
                public void refresh() {
                }
            });
            return (AmazonS3)builder.build();
        }

        private void validate() {
            String accessKey = S3Client.getOpt(this.cfg, "access-key", Object::toString, "");
            String secretKey = S3Client.getOpt(this.cfg, "secret-key", Object::toString, "");
            Preconditions.checkArgument((!accessKey.isEmpty() ? 1 : 0) != 0, (Object)"access-key must not be empty");
            Preconditions.checkArgument((!secretKey.isEmpty() ? 1 : 0) != 0, (Object)"secret-key must not be empty");
        }

        static {
            UPDATERS.put("path-style-access", (BiConsumer<Object, AmazonS3ClientBuilder>)(BiConsumer & Serializable)(value, builder) -> builder.setPathStyleAccessEnabled(Boolean.valueOf(value.toString())));
            UPDATERS.put("endpoint", (BiConsumer<Object, AmazonS3ClientBuilder>)(BiConsumer & Serializable)(value, builder) -> builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(value.toString(), AmazonS3Factory.endpoint(builder).getSigningRegion())));
            UPDATERS.put("signing-region", (BiConsumer<Object, AmazonS3ClientBuilder>)(BiConsumer & Serializable)(value, builder) -> builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(AmazonS3Factory.endpoint(builder).getServiceEndpoint(), value.toString())));
            UPDATERS.put("ssl-enabled", (BiConsumer<Object, AmazonS3ClientBuilder>)(BiConsumer & Serializable)(value, builder) -> {
                if (!Boolean.getBoolean(value.toString())) {
                    AmazonS3Factory.clientConfiguration(builder).setProtocol(Protocol.HTTP);
                }
            });
            UPDATERS.put("region", (BiConsumer<Object, AmazonS3ClientBuilder>)(BiConsumer & Serializable)(value, builder) -> builder.setRegion(value.toString()));
        }
    }
}

