/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.s3;

import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import cz.o2.proxima.direct.blob.BlobPath;
import cz.o2.proxima.direct.bulk.FileSystem;
import cz.o2.proxima.direct.bulk.NamingConvention;
import cz.o2.proxima.direct.bulk.Path;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.s3.S3Accessor;
import cz.o2.proxima.direct.s3.S3BlobPath;
import cz.o2.proxima.direct.s3.S3Client;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileSystem
extends S3Client
implements FileSystem {
    private static final Logger log = LoggerFactory.getLogger(S3FileSystem.class);
    private static final long serialVersionUID = 1L;
    private final URI uri;
    private final NamingConvention namingConvention;
    private final Context context;

    S3FileSystem(S3Accessor accessor, Context context) {
        super(accessor.getUri(), accessor.getCfg());
        this.uri = accessor.getUri();
        this.namingConvention = accessor.getNamingConvention();
        this.context = context;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Stream<Path> list(long minTs, long maxTs) {
        return this.getBlobsInRange(minTs, maxTs).stream().map(blob -> S3BlobPath.of(this.context, this, blob));
    }

    @Override
    public Path newPath(long ts) {
        return S3BlobPath.of(this.context, this, BlobPath.normalizePath(this.getUri().getPath() + this.namingConvention.nameOf(ts)));
    }

    private List<String> getBlobsInRange(long startStamp, long endStamp) {
        Collection prefixes = this.namingConvention.prefixesOf(startStamp, endStamp).stream().map(e -> BlobPath.normalizePath(this.getUri().getPath() + e)).collect(Collectors.toList());
        List<String> ret = prefixes.stream().flatMap(prefix -> {
            ObjectListing listing = this.client().listObjects(this.getBucket(), (String)prefix);
            return listing.getObjectSummaries().stream().map(S3ObjectSummary::getKey).filter(name -> this.namingConvention.isInRange((String)name, startStamp, endStamp)).sorted();
        }).collect(Collectors.toList());
        log.debug("Parsed partitions {} for startStamp {}, endStamp {}", ret, startStamp, endStamp);
        return ret;
    }
}

