/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.s3.shaded.org.joda.time.base;

import cz.o2.proxima.s3.shaded.org.joda.time.Chronology;
import cz.o2.proxima.s3.shaded.org.joda.time.DateTimeUtils;
import cz.o2.proxima.s3.shaded.org.joda.time.DateTimeZone;
import cz.o2.proxima.s3.shaded.org.joda.time.ReadableDateTime;
import cz.o2.proxima.s3.shaded.org.joda.time.base.AbstractDateTime;
import cz.o2.proxima.s3.shaded.org.joda.time.chrono.ISOChronology;
import cz.o2.proxima.s3.shaded.org.joda.time.convert.ConverterManager;
import cz.o2.proxima.s3.shaded.org.joda.time.convert.InstantConverter;
import java.io.Serializable;

public abstract class BaseDateTime
extends AbstractDateTime
implements ReadableDateTime,
Serializable {
    private static final long serialVersionUID = -6728882245981L;
    private volatile long iMillis;
    private volatile Chronology iChronology;

    public BaseDateTime() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public BaseDateTime(DateTimeZone dateTimeZone) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(dateTimeZone));
    }

    public BaseDateTime(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    public BaseDateTime(long l) {
        this(l, (Chronology)ISOChronology.getInstance());
    }

    public BaseDateTime(long l, DateTimeZone dateTimeZone) {
        this(l, (Chronology)ISOChronology.getInstance(dateTimeZone));
    }

    public BaseDateTime(long l, Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
        this.iMillis = this.checkInstant(l, this.iChronology);
        if (this.iChronology.year().isSupported()) {
            this.iChronology.year().set(this.iMillis, this.iChronology.year().get(this.iMillis));
        }
    }

    public BaseDateTime(Object object, DateTimeZone dateTimeZone) {
        Chronology chronology;
        InstantConverter instantConverter = ConverterManager.getInstance().getInstantConverter(object);
        this.iChronology = chronology = this.checkChronology(instantConverter.getChronology(object, dateTimeZone));
        this.iMillis = this.checkInstant(instantConverter.getInstantMillis(object, chronology), chronology);
    }

    public BaseDateTime(Object object, Chronology chronology) {
        InstantConverter instantConverter = ConverterManager.getInstance().getInstantConverter(object);
        this.iChronology = this.checkChronology(instantConverter.getChronology(object, chronology));
        this.iMillis = this.checkInstant(instantConverter.getInstantMillis(object, chronology), this.iChronology);
    }

    public BaseDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(n, n2, n3, n4, n5, n6, n7, ISOChronology.getInstance());
    }

    public BaseDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, DateTimeZone dateTimeZone) {
        this(n, n2, n3, n4, n5, n6, n7, ISOChronology.getInstance(dateTimeZone));
    }

    public BaseDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
        long l = this.iChronology.getDateTimeMillis(n, n2, n3, n4, n5, n6, n7);
        this.iMillis = this.checkInstant(l, this.iChronology);
    }

    protected Chronology checkChronology(Chronology chronology) {
        return DateTimeUtils.getChronology(chronology);
    }

    protected long checkInstant(long l, Chronology chronology) {
        return l;
    }

    public long getMillis() {
        return this.iMillis;
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    protected void setMillis(long l) {
        this.iMillis = this.checkInstant(l, this.iChronology);
    }

    protected void setChronology(Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
    }
}

