/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.blob;

import cz.o2.proxima.direct.blob.BlobBase;
import cz.o2.proxima.direct.bulk.FileSystem;
import cz.o2.proxima.direct.bulk.Path;
import cz.o2.proxima.internal.shaded.com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.internal.shaded.com.google.common.base.MoreObjects;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class BlobPath<BlobT extends BlobBase>
implements Path {
    private static final long serialVersionUID = 1L;
    private final FileSystem fs;
    private final BlobT blob;

    protected BlobPath(FileSystem fs, BlobT blob) {
        this.fs = fs;
        this.blob = (BlobBase)Objects.requireNonNull(blob);
    }

    @Override
    public abstract InputStream reader();

    @Override
    public abstract OutputStream writer();

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public abstract void delete();

    public BlobT getBlob() {
        return this.blob;
    }

    public String getBlobName() {
        return this.blob.getName();
    }

    @Override
    public int compareTo(@Nonnull Path other) {
        return this.getBlobName().compareTo(((BlobPath)other).getBlobName());
    }

    public int hashCode() {
        return Objects.hash(this.getFileSystem().getUri(), this.getBlobName().hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BlobPath)) {
            return false;
        }
        BlobPath other = (BlobPath)obj;
        return other.getFileSystem().getUri().equals(this.getFileSystem().getUri()) && other.getBlobName().equals(this.getBlobName());
    }

    @VisibleForTesting
    public static String normalizePath(String path) {
        StringBuilder sb = new StringBuilder();
        boolean lastSlash = true;
        for (char ch : path.toCharArray()) {
            if (ch == '/') {
                if (lastSlash) continue;
                lastSlash = true;
                sb.append(ch);
                continue;
            }
            lastSlash = false;
            sb.append(ch);
        }
        return sb.toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uri", (Object)this.getFileSystem().getUri()).add("blobName", (Object)this.getBlobName()).toString();
    }
}

