/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.blob;

import cz.o2.proxima.direct.bulk.FileFormat;
import cz.o2.proxima.direct.bulk.FileFormatUtils;
import cz.o2.proxima.direct.bulk.FileSystem;
import cz.o2.proxima.direct.bulk.NamingConvention;
import cz.o2.proxima.direct.core.DataAccessor;
import cz.o2.proxima.internal.shaded.com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.repository.AttributeFamilyDescriptor;
import cz.o2.proxima.storage.AbstractStorage;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public abstract class BlobStorageAccessor
extends AbstractStorage.SerializableAbstractStorage
implements DataAccessor {
    private static final long serialVersionUID = 1L;
    public static final String LOG_ROLL_INTERVAL = "log-roll-interval";
    public static final String ALLOWED_LATENESS_MS = "allowed-lateness-ms";
    public static final String PARTITION_SIZE = "partition.size";
    public static final String PARTITION_MAX_BLOBS = "partition.max-blobs";
    public static final String PARTITION_MAX_TIME_SPAN_MS = "partition.max-time-span-ms";
    final AttributeFamilyDescriptor familyDescriptor;
    final Map<String, Object> cfg;

    protected BlobStorageAccessor(AttributeFamilyDescriptor family) {
        super(family.getEntity(), family.getStorageUri());
        this.familyDescriptor = family;
        this.cfg = new HashMap<String, Object>(family.getCfg());
    }

    public Map<String, Object> getCfg() {
        return Collections.unmodifiableMap(this.cfg);
    }

    @VisibleForTesting
    void setCfg(String key, Object value) {
        this.cfg.put(key, value);
    }

    public abstract FileSystem getTargetFileSystem();

    FileFormat getFileFormat() {
        FileFormat format = FileFormatUtils.getFileFormat("", this.getCfg());
        format.setup(this.familyDescriptor);
        return format;
    }

    public NamingConvention getNamingConvention() {
        return FileFormatUtils.getNamingConvention("", this.getCfg(), this.getRollPeriod(), this.getFileFormat());
    }

    public File getTmpDir() {
        File parent = Optional.ofNullable(this.getCfg().get("tmp.dir")).map(Object::toString).map(File::new).orElse(new File(System.getProperty("java.io.tmpdir")));
        return new File(parent, "blob-local-storage-" + UUID.randomUUID());
    }

    public long getRollPeriod() {
        return Optional.ofNullable(this.getCfg().get(LOG_ROLL_INTERVAL)).map(Object::toString).map(Long::valueOf).orElse(3600000L);
    }

    public long getAllowedLateness() {
        return Optional.ofNullable(this.getCfg().get(ALLOWED_LATENESS_MS)).map(Object::toString).map(Long::valueOf).orElse(300000L);
    }

    public long getPartitionMinSize() {
        return Optional.ofNullable(this.getCfg().get(PARTITION_SIZE)).map(Object::toString).map(Long::valueOf).orElse(0x6400000L);
    }

    public int getPartitionMaxNumBlobs() {
        return Optional.ofNullable(this.getCfg().get(PARTITION_MAX_BLOBS)).map(Object::toString).map(Integer::valueOf).orElse(1000);
    }

    public long getPartitionMaxTimeSpanMs() {
        return Optional.ofNullable(this.getCfg().get(PARTITION_MAX_TIME_SPAN_MS)).map(Object::toString).map(Long::valueOf).orElse(-1L);
    }
}

