/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.blob;

import cz.o2.proxima.direct.blob.BlobBase;
import cz.o2.proxima.direct.blob.BlobPath;
import cz.o2.proxima.direct.blob.BlobStorageAccessor;
import cz.o2.proxima.direct.bulk.AbstractBulkFileSystemAttributeWriter;
import cz.o2.proxima.direct.bulk.FileSystem;
import cz.o2.proxima.direct.bulk.Path;
import cz.o2.proxima.direct.core.AttributeWriterBase;
import cz.o2.proxima.direct.core.BulkAttributeWriter;
import cz.o2.proxima.direct.core.CommitCallback;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.internal.shaded.com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.internal.shaded.com.google.common.io.ByteStreams;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.storage.StreamElement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BulkBlobWriter<BlobT extends BlobBase, AccessorT extends BlobStorageAccessor>
implements BulkAttributeWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkBlobWriter.class);
    private final AccessorT accessor;
    private final Context context;
    private final BulkAttributeWriter wrap;
    private final File tmpDir;

    public BulkBlobWriter(AccessorT accessor, Context context) {
        this.accessor = accessor;
        this.context = context;
        this.tmpDir = ((BlobStorageAccessor)((Object)accessor)).getTmpDir();
        FileSystem localFs = FileSystem.local(this.tmpDir, ((BlobStorageAccessor)((Object)accessor)).getNamingConvention());
        this.wrap = new BlobFileSystemAttributeWriter(localFs);
        if (this.tmpDir.exists() && this.tmpDir.isDirectory()) {
            this.removeDir(this.tmpDir);
        }
        if (this.tmpDir.exists()) {
            throw new IllegalStateException("Temporary directory " + this.tmpDir + " exists and is not directory");
        }
        Preconditions.checkArgument((boolean)this.tmpDir.mkdirs());
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.accessor.getEntityDescriptor();
    }

    public URI getUri() {
        return this.accessor.getUri();
    }

    public void write(StreamElement data, long watermark, CommitCallback statusCallback) {
        this.wrap.write(data, watermark, statusCallback);
    }

    public void updateWatermark(long watermark) {
        Optional.ofNullable(this.wrap).ifPresent(w -> w.updateWatermark(watermark));
    }

    public void rollback() {
        Optional.ofNullable(this.wrap).ifPresent(AttributeWriterBase::rollback);
    }

    private void removeDir(File dir) {
        Preconditions.checkArgument((boolean)dir.isDirectory());
        if (dir.exists()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (f.isDirectory()) {
                        this.removeDir(f);
                    }
                    Preconditions.checkState((boolean)f.delete());
                }
            }
            Preconditions.checkState((boolean)dir.delete());
        }
    }

    @VisibleForTesting
    void flush() {
        this.updateWatermark(Long.MAX_VALUE);
    }

    private void flush(Path file, long bucketEndStamp) {
        BlobPath targetPath = (BlobPath)((BlobStorageAccessor)((Object)this.accessor)).getTargetFileSystem().newPath(bucketEndStamp - 1L);
        try (InputStream in = file.reader();
             OutputStream out = targetPath.writer();){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
            out.close();
            this.deleteHandlingErrors(file);
        }
        catch (Exception ex) {
            log.warn("Error while putting object {} to {}", file, targetPath, ex);
            this.deleteBlobIfExists(targetPath.getBlob());
            throw new IllegalStateException(ex);
        }
        log.info("Flushed source path {} to {}", (Object)file, (Object)targetPath);
    }

    protected abstract void deleteBlobIfExists(BlobT var1);

    private void deleteHandlingErrors(Path f) {
        try {
            f.delete();
        }
        catch (IOException ex) {
            log.warn("Failed to delete {}. Ignoring", (Object)f, (Object)ex);
        }
    }

    public void close() {
        Optional.ofNullable(this.wrap).ifPresent(AttributeWriterBase::close);
        if (this.tmpDir.exists() && this.tmpDir.isDirectory()) {
            try {
                this.removeDir(this.tmpDir);
            }
            catch (Exception ex) {
                log.error("Failed to remove directory {}. Ignored.", (Object)this.tmpDir, (Object)ex);
            }
        }
    }

    @Generated
    public AccessorT getAccessor() {
        return this.accessor;
    }

    @Generated
    public Context getContext() {
        return this.context;
    }

    private class BlobFileSystemAttributeWriter
    extends AbstractBulkFileSystemAttributeWriter {
        public BlobFileSystemAttributeWriter(FileSystem localFs) {
            super(BulkBlobWriter.this.getEntityDescriptor(), BulkBlobWriter.this.accessor.getUri(), localFs, BulkBlobWriter.this.accessor.getNamingConvention(), BulkBlobWriter.this.accessor.getFileFormat(), BulkBlobWriter.this.context, BulkBlobWriter.this.accessor.getRollPeriod(), BulkBlobWriter.this.accessor.getAllowedLateness());
        }

        @Override
        protected void flush(AbstractBulkFileSystemAttributeWriter.Bulk bulk) {
            BulkBlobWriter.this.flush(bulk.getPath(), bulk.getMaxTs());
        }

        public BulkAttributeWriter.Factory<?> asFactory() {
            throw new UnsupportedOperationException("This should not be called directly");
        }
    }
}

