/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.bulk;

import cz.o2.proxima.direct.bulk.DefaultNamingConventionFactory;
import cz.o2.proxima.direct.bulk.FileFormat;
import cz.o2.proxima.direct.bulk.NamingConvention;
import cz.o2.proxima.direct.bulk.NamingConventionFactory;
import cz.o2.proxima.util.Classpath;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFormatUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileFormatUtils.class);

    public static NamingConvention getNamingConvention(String cfgPrefix, Map<String, Object> cfg, long rollPeriodMs, FileFormat format) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(InetAddress.getLocalHost().getHostName().getBytes(Charset.defaultCharset()));
            String prefix = new String(Base64.getEncoder().withoutPadding().encode(digest.digest())).substring(0, 10).replace('/', '-');
            String namingConventionKey = cfgPrefix + "naming-convention";
            String namingConventionFactoryKey = cfgPrefix + "naming-convention-factory";
            if (cfg.containsKey(namingConventionKey)) {
                log.warn(String.format("Legacy configuration being used '%s' prefer to use configuration '%s'", namingConventionKey, namingConventionFactoryKey));
                return (NamingConvention)Classpath.newInstance((String)cfg.get(namingConventionKey).toString(), NamingConvention.class);
            }
            return Optional.ofNullable(cfg.get(namingConventionFactoryKey)).map(Object::toString).map(cls -> (NamingConventionFactory)Classpath.newInstance((String)cls, NamingConventionFactory.class)).orElse(new DefaultNamingConventionFactory()).create(cfgPrefix, cfg, Duration.ofMillis(rollPeriodMs), prefix, format.fileSuffix());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static FileFormat getFileFormat(String cfgPrefix, Map<String, Object> cfg) {
        String format = Optional.ofNullable(cfg.get(cfgPrefix + "format")).map(Object::toString).orElse("binary");
        boolean gzip = Optional.ofNullable(cfg.get(cfgPrefix + "gzip")).map(Object::toString).map(Boolean::valueOf).orElse(false);
        return FileFormatUtils.getFileFormatFromName(format, gzip);
    }

    static FileFormat getFileFormatFromName(String format, boolean gzip) {
        if ("binary".equals(format)) {
            return FileFormat.blob(gzip);
        }
        if ("json".equals(format)) {
            return FileFormat.json(gzip);
        }
        if ("parquet".equals(format)) {
            format = "cz.o2.proxima.direct.bulk.fs.parquet.ParquetFileFormat";
        }
        try {
            return (FileFormat)Classpath.newInstance((String)format, FileFormat.class);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unknown format " + format, ex);
        }
    }

    private FileFormatUtils() {
    }
}

