/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.bulk;

import cz.o2.proxima.direct.bulk.FileSystem;
import cz.o2.proxima.direct.bulk.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import lombok.Generated;

public class LocalPath
implements Path {
    private static final long serialVersionUID = 1L;
    private final File path;
    private final FileSystem fs;

    public LocalPath(File path, FileSystem fs) {
        this.path = path;
        this.fs = fs;
    }

    @Override
    public InputStream reader() throws IOException {
        return new FileInputStream(this.path);
    }

    @Override
    public OutputStream writer() throws IOException {
        if (!this.path.getParentFile().exists() && !this.path.getParentFile().mkdirs()) {
            throw new IOException("Failed to create dir " + this.path.getParentFile());
        }
        return new FileOutputStream(this.path);
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public void delete() throws IOException {
        if (this.path.exists()) {
            Files.delete(Paths.get(this.path.toURI()));
        }
    }

    public String toString() {
        return this.path.getAbsolutePath();
    }

    @Override
    public int compareTo(@Nonnull Path other) {
        return this.path.compareTo(((LocalPath)other).getPath());
    }

    @Generated
    public File getPath() {
        return this.path;
    }
}

