/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.bulk;

import cz.o2.proxima.direct.bulk.DefaultNamingConvention;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.util.Pair;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.stream.Collectors;

public interface NamingConvention
extends Serializable {
    public static NamingConvention defaultConvention(Duration rollTimePeriod, String prefix, String suffix) {
        return new DefaultNamingConvention(rollTimePeriod, prefix, suffix);
    }

    public static NamingConvention prefixed(final String prefix, final NamingConvention parent) {
        return new NamingConvention(){
            private static final long serialVersionUID = 1L;

            @Override
            public String nameOf(long ts) {
                return prefix + parent.nameOf(ts);
            }

            @Override
            public Collection<String> prefixesOf(long minTs, long maxTs) {
                return parent.prefixesOf(minTs, maxTs).stream().map(p -> prefix + p).collect(Collectors.toList());
            }

            @Override
            public boolean isInRange(String name, long minTs, long maxTs) {
                Preconditions.checkArgument((boolean)name.startsWith(prefix));
                return parent.isInRange(name.substring(prefix.length()), minTs, maxTs);
            }

            @Override
            public Pair<Long, Long> parseMinMaxTimestamp(String name) {
                Preconditions.checkArgument((boolean)name.startsWith(prefix));
                return parent.parseMinMaxTimestamp(name.substring(prefix.length()));
            }
        };
    }

    public String nameOf(long var1);

    public Collection<String> prefixesOf(long var1, long var3);

    public boolean isInRange(String var1, long var2, long var4);

    public Pair<Long, Long> parseMinMaxTimestamp(String var1);
}

