/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.bulk;

import cz.o2.proxima.direct.bulk.FileFormat;
import cz.o2.proxima.direct.bulk.FileSystem;
import cz.o2.proxima.direct.bulk.LocalPath;
import cz.o2.proxima.direct.bulk.NamingConvention;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.time.Duration;
import javax.annotation.Nonnull;

public interface Path
extends Serializable,
Comparable<Path> {
    public static LocalPath local(FileSystem fs, File path) {
        return new LocalPath(path, fs);
    }

    public static Path stdin(final FileFormat format) {
        return new Path(){
            private static final long serialVersionUID = 1L;

            @Override
            public int compareTo(@Nonnull Path path) {
                return 0;
            }

            @Override
            public InputStream reader() {
                return System.in;
            }

            @Override
            public OutputStream writer() {
                throw new UnsupportedOperationException("Can only read from stdin.");
            }

            @Override
            public FileSystem getFileSystem() {
                return FileSystem.local(new File("/dev/stdin"), NamingConvention.defaultConvention(Duration.ofHours(1L), "prefix", format.fileSuffix()));
            }

            @Override
            public void delete() {
                throw new UnsupportedOperationException("Cannot delete stdin.");
            }
        };
    }

    default public ReadableByteChannel read() throws IOException {
        return Channels.newChannel(this.reader());
    }

    @Deprecated
    public InputStream reader() throws IOException;

    default public WritableByteChannel write() throws IOException {
        return Channels.newChannel(this.writer());
    }

    @Deprecated
    public OutputStream writer() throws IOException;

    public FileSystem getFileSystem();

    public void delete() throws IOException;
}

