/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.s3;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import cz.o2.proxima.direct.blob.BlobBase;
import cz.o2.proxima.direct.blob.BlobPath;
import cz.o2.proxima.direct.bulk.Path;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.s3.S3Client;
import cz.o2.proxima.direct.s3.S3FileSystem;
import cz.o2.proxima.s3.shaded.com.amazonaws.AmazonClientException;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.model.GetObjectRequest;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.model.S3Object;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.model.SSECustomerKey;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BlobPath
extends BlobPath<S3Blob>
implements Path {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3BlobPath.class);
    private static final long serialVersionUID = 1L;
    private final Context context;

    public static S3BlobPath of(Context context, S3FileSystem fs, String name) {
        return new S3BlobPath(context, fs, new S3Blob(name, fs));
    }

    public static S3BlobPath of(Context context, S3FileSystem fs, String name, long size) {
        return new S3BlobPath(context, fs, new S3Blob(name, size));
    }

    @VisibleForTesting
    S3BlobPath(Context context, S3FileSystem fs, S3Blob blob) {
        super(fs, blob);
        this.context = Objects.requireNonNull(context);
    }

    @Override
    public ReadableByteChannel read() {
        final long contentLength = ((S3Blob)this.getBlob()).getSize();
        return new SeekableByteChannel(){
            private boolean open = true;
            private S3Object object;
            private ReadableByteChannel contentChannel;
            private long position = 0L;

            @Override
            public int read(ByteBuffer dst) throws IOException {
                this.ensureOpen();
                if (this.position >= contentLength) {
                    return -1;
                }
                if (this.object == null) {
                    S3FileSystem fs = (S3FileSystem)S3BlobPath.this.getFileSystem();
                    GetObjectRequest request = new GetObjectRequest(fs.getBucket(), S3BlobPath.this.getBlobName());
                    SSECustomerKey sseCustomerKey = fs.getSseCustomerKey();
                    if (sseCustomerKey != null) {
                        request.setSSECustomerKey(sseCustomerKey);
                    }
                    if (this.position > 0L) {
                        request.setRange(this.position, contentLength);
                    }
                    this.object = fs.client().getObject(request);
                    this.contentChannel = Channels.newChannel(new BufferedInputStream(this.object.getObjectContent(), 0x100000));
                }
                int totalBytesRead = 0;
                int bytesRead = 0;
                do {
                    totalBytesRead += bytesRead;
                    try {
                        bytesRead = this.contentChannel.read(dst);
                    }
                    catch (AmazonClientException e) {
                        throw new IOException(e);
                    }
                } while (bytesRead > 0);
                this.position += (long)totalBytesRead;
                return totalBytesRead;
            }

            @Override
            public long position() throws IOException {
                this.ensureOpen();
                return this.position;
            }

            @Override
            public SeekableByteChannel position(long newPosition) throws IOException {
                this.ensureOpen();
                Preconditions.checkArgument((newPosition >= 0L ? 1 : 0) != 0, (Object)"New position is too low.");
                Preconditions.checkArgument((newPosition < contentLength ? 1 : 0) != 0, (Object)"New position is too high.");
                if (newPosition == this.position) {
                    return this;
                }
                if (this.object != null) {
                    this.object.close();
                    this.object = null;
                }
                this.position = newPosition;
                return this;
            }

            @Override
            public long size() throws IOException {
                this.ensureOpen();
                return contentLength;
            }

            @Override
            public boolean isOpen() {
                return this.open;
            }

            @Override
            public void close() throws IOException {
                if (this.object != null) {
                    this.object.close();
                    this.object = null;
                }
                this.open = false;
            }

            @Override
            public int write(ByteBuffer src) {
                throw new NonWritableChannelException();
            }

            @Override
            public SeekableByteChannel truncate(long size) {
                throw new NonWritableChannelException();
            }

            private void ensureOpen() throws IOException {
                if (!this.open) {
                    throw new ClosedChannelException();
                }
            }
        };
    }

    @Override
    public InputStream reader() {
        return Channels.newInputStream(this.read());
    }

    @Override
    public OutputStream writer() {
        return ((S3Client)((Object)this.getFileSystem())).putObject(this.getBlobName());
    }

    @Override
    public void delete() {
        ((S3Client)((Object)this.getFileSystem())).deleteObject(((S3Blob)this.getBlob()).getName());
    }

    public static class S3Blob
    implements BlobBase {
        private final String name;
        private final long size;
        @Nullable
        private final S3FileSystem fs;

        S3Blob(String name, long size) {
            Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"Unknown size.");
            this.name = Objects.requireNonNull(name);
            this.size = size;
            this.fs = null;
        }

        @VisibleForTesting
        S3Blob(String name, S3FileSystem fs) {
            this.name = Objects.requireNonNull(name);
            this.size = -1L;
            this.fs = Objects.requireNonNull(fs);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long getSize() {
            if (this.size > -1L) {
                return this.size;
            }
            Objects.requireNonNull(this.fs);
            try (S3Object object = this.fs.getObject(this.name);){
                long l = object.getObjectMetadata().getContentLength();
                return l;
            }
            catch (Exception e) {
                log.warn("Unable to retrieve object size of [{}] from [{}].", this.name, this.fs.getUri(), e);
                return 0L;
            }
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }
    }
}

