/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.s3;

import cz.o2.proxima.direct.blob.BlobPath;
import cz.o2.proxima.direct.bulk.FileSystem;
import cz.o2.proxima.direct.bulk.NamingConvention;
import cz.o2.proxima.direct.bulk.Path;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.s3.S3Accessor;
import cz.o2.proxima.direct.s3.S3BlobPath;
import cz.o2.proxima.direct.s3.S3Client;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.model.ObjectListing;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.model.S3ObjectSummary;
import java.net.URI;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileSystem
extends S3Client
implements FileSystem {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3FileSystem.class);
    private static final long serialVersionUID = 1L;
    private final URI uri;
    private final NamingConvention namingConvention;
    private final Context context;

    S3FileSystem(S3Accessor accessor, Context context) {
        super(accessor.getUri(), accessor.getCfg());
        this.uri = accessor.getUri();
        this.namingConvention = accessor.getNamingConvention();
        this.context = context;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Stream<Path> list(long minTs, long maxTs) {
        List<S3BlobPath> blobs = this.getBlobsInRange(minTs, maxTs);
        return blobs.stream();
    }

    @Override
    public Path newPath(long ts) {
        return S3BlobPath.of(this.context, this, BlobPath.normalizePath(this.getUri().getPath() + this.namingConvention.nameOf(ts)));
    }

    private List<S3BlobPath> getBlobsInRange(long startStamp, long endStamp) {
        Collection prefixes = this.namingConvention.prefixesOf(startStamp, endStamp).stream().map(e -> BlobPath.normalizePath(this.getUri().getPath() + e)).collect(Collectors.toList());
        List<S3BlobPath> ret = prefixes.stream().flatMap(prefix -> {
            ObjectListing listing = this.client().listObjects(this.getBucket(), (String)prefix);
            return listing.getObjectSummaries().stream().filter(summary -> this.namingConvention.isInRange(summary.getKey(), startStamp, endStamp)).sorted(Comparator.comparing(S3ObjectSummary::getKey)).map(summary -> S3BlobPath.of(this.context, this, summary.getKey(), summary.getSize()));
        }).collect(Collectors.toList());
        if (log.isDebugEnabled()) {
            log.debug("Parsed partitions {} for startStamp {}, endStamp {}", ret.stream().map(BlobPath::getBlobName).collect(Collectors.toList()), startStamp, endStamp);
        }
        return ret;
    }
}

