/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.s3;

import cz.o2.proxima.direct.batch.BatchLogReader;
import cz.o2.proxima.direct.blob.BlobLogReader;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.s3.S3Accessor;
import cz.o2.proxima.direct.s3.S3BlobPath;
import cz.o2.proxima.direct.s3.S3FileSystem;
import cz.o2.proxima.util.ExceptionUtils;
import java.io.Serializable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3LogReader
extends BlobLogReader<S3BlobPath.S3Blob, S3BlobPath> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3LogReader.class);
    private final S3FileSystem fs;
    private final Context context;

    public S3LogReader(S3Accessor accessor, Context context) {
        super(accessor, context);
        this.fs = new S3FileSystem(accessor, context);
        this.context = context;
    }

    @Override
    protected void runHandlingErrors(S3BlobPath.S3Blob blob, BlobLogReader.ThrowingRunnable runnable) {
        this.fs.getRetry().retry(() -> ExceptionUtils.unchecked(runnable::run));
    }

    protected S3BlobPath createPath(S3BlobPath.S3Blob blob) {
        return new S3BlobPath(this.context, this.fs, blob);
    }

    public BatchLogReader.Factory<?> asFactory() {
        S3Accessor accessor = (S3Accessor)this.getAccessor();
        Context context = this.getContext();
        return (BatchLogReader.Factory & Serializable)repo -> new S3LogReader(accessor, context);
    }
}

