/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.s3.shaded.com.amazonaws.endpointdiscovery;

import cz.o2.proxima.s3.shaded.com.amazonaws.AmazonWebServiceRequest;
import cz.o2.proxima.s3.shaded.com.amazonaws.SdkClientException;
import cz.o2.proxima.s3.shaded.com.amazonaws.annotation.SdkInternalApi;
import cz.o2.proxima.s3.shaded.com.amazonaws.cache.EndpointDiscoveryCacheLoader;
import cz.o2.proxima.s3.shaded.com.amazonaws.endpointdiscovery.DaemonThreadFactory;
import cz.o2.proxima.s3.shaded.org.apache.commons.logging.Log;
import cz.o2.proxima.s3.shaded.org.apache.commons.logging.LogFactory;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@SdkInternalApi
public abstract class EndpointDiscoveryIdentifiersRefreshCache<K> {
    private static final Log log = LogFactory.getLog(EndpointDiscoveryIdentifiersRefreshCache.class);
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(DaemonThreadFactory.INSTANCE);
    private final EndpointDiscoveryCacheLoader<String, Map<String, String>> cacheLoader;
    protected final Map<String, URI> cache = new ConcurrentHashMap<String, URI>();

    public EndpointDiscoveryIdentifiersRefreshCache(EndpointDiscoveryCacheLoader cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public abstract URI get(K var1, AmazonWebServiceRequest var2, boolean var3, URI var4);

    public abstract URI put(String var1, AmazonWebServiceRequest var2, Map<String, String> var3, URI var4);

    public abstract String constructKey(String var1, AmazonWebServiceRequest var2);

    public void evict(String key) {
        this.cache.remove(key);
    }

    public URI discoverEndpoint(String key, AmazonWebServiceRequest request, boolean required, URI defaultEndpoint) {
        if (required) {
            try {
                return this.put(key, request, this.cacheLoader.load(key, request), defaultEndpoint);
            }
            catch (Exception e) {
                throw new SdkClientException("Unable to discover required endpoint for request.", e);
            }
        }
        this.loadAndScheduleRefresh(key, request, 1L, defaultEndpoint);
        return defaultEndpoint;
    }

    public ScheduledFuture<URI> loadAndScheduleRefresh(final String key, final AmazonWebServiceRequest request, long refreshPeriod, final URI defaultEndpoint) {
        return this.executorService.schedule(new Callable<URI>(){

            @Override
            public URI call() {
                try {
                    return EndpointDiscoveryIdentifiersRefreshCache.this.put(key, request, (Map)EndpointDiscoveryIdentifiersRefreshCache.this.cacheLoader.load(key, request), defaultEndpoint);
                }
                catch (Exception e) {
                    log.debug("Failed to refresh cached endpoint. Scheduling another refresh in 5 minutes");
                    EndpointDiscoveryIdentifiersRefreshCache.this.loadAndScheduleRefresh(key, request, 5L, defaultEndpoint);
                    return null;
                }
            }
        }, refreshPeriod, TimeUnit.MINUTES);
    }

    public void shutdown() {
        this.executorService.shutdownNow();
    }
}

