/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.s3.shaded.com.amazonaws.http.conn;

import cz.o2.proxima.s3.shaded.com.amazonaws.http.conn.Wrapped;
import cz.o2.proxima.s3.shaded.com.amazonaws.metrics.AwsSdkMetrics;
import cz.o2.proxima.s3.shaded.com.amazonaws.metrics.ServiceLatencyProvider;
import cz.o2.proxima.s3.shaded.com.amazonaws.metrics.ServiceMetricCollector;
import cz.o2.proxima.s3.shaded.com.amazonaws.util.AWSServiceMetrics;
import cz.o2.proxima.s3.shaded.org.apache.commons.logging.Log;
import cz.o2.proxima.s3.shaded.org.apache.commons.logging.LogFactory;
import cz.o2.proxima.s3.shaded.org.apache.http.conn.ConnectionRequest;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class ClientConnectionRequestFactory {
    private static final Log log = LogFactory.getLog(ClientConnectionRequestFactory.class);
    private static final Class<?>[] interfaces = new Class[]{ConnectionRequest.class, Wrapped.class};

    ClientConnectionRequestFactory() {
    }

    static ConnectionRequest wrap(ConnectionRequest orig) {
        if (orig instanceof Wrapped) {
            throw new IllegalArgumentException();
        }
        return (ConnectionRequest)Proxy.newProxyInstance(ClientConnectionRequestFactory.class.getClassLoader(), interfaces, (InvocationHandler)new Handler(orig));
    }

    private static class Handler
    implements InvocationHandler {
        private final ConnectionRequest orig;

        Handler(ConnectionRequest orig) {
            this.orig = orig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!"get".equals(method.getName())) return method.invoke((Object)this.orig, args);
            ServiceLatencyProvider latencyProvider = new ServiceLatencyProvider(AWSServiceMetrics.HttpClientGetConnectionTime);
            try {
                Object object = method.invoke((Object)this.orig, args);
                ((ServiceMetricCollector)AwsSdkMetrics.getServiceMetricCollector()).collectLatency(latencyProvider.endTiming());
                return object;
            }
            catch (Throwable throwable) {
                try {
                    ((ServiceMetricCollector)AwsSdkMetrics.getServiceMetricCollector()).collectLatency(latencyProvider.endTiming());
                    throw throwable;
                }
                catch (InvocationTargetException e) {
                    log.debug("", e);
                    throw e.getCause();
                }
            }
        }
    }
}

