/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.s3.shaded.com.amazonaws.regions;

import cz.o2.proxima.s3.shaded.com.amazonaws.SdkClientException;
import cz.o2.proxima.s3.shaded.com.amazonaws.auth.AWSCredentialsProviderChain;
import cz.o2.proxima.s3.shaded.com.amazonaws.regions.AwsRegionProvider;
import cz.o2.proxima.s3.shaded.org.apache.commons.logging.Log;
import cz.o2.proxima.s3.shaded.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AwsRegionProviderChain
extends AwsRegionProvider {
    private static final Log LOG = LogFactory.getLog(AWSCredentialsProviderChain.class);
    private final List<AwsRegionProvider> providers;

    public AwsRegionProviderChain(AwsRegionProvider ... providers) {
        this.providers = new ArrayList<AwsRegionProvider>(providers.length);
        Collections.addAll(this.providers, providers);
    }

    @Override
    public String getRegion() throws SdkClientException {
        for (AwsRegionProvider provider : this.providers) {
            try {
                String region = provider.getRegion();
                if (region == null) continue;
                return region;
            }
            catch (Exception e) {
                LOG.debug("Unable to load region from " + provider.toString() + ": " + e.getMessage());
            }
        }
        throw new SdkClientException("Unable to load region information from any provider in the chain");
    }
}

