/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.s3.shaded.com.amazonaws.retry;

import cz.o2.proxima.s3.shaded.com.amazonaws.AmazonClientException;
import cz.o2.proxima.s3.shaded.com.amazonaws.AmazonWebServiceRequest;
import cz.o2.proxima.s3.shaded.com.amazonaws.ClientConfiguration;
import cz.o2.proxima.s3.shaded.com.amazonaws.annotation.SdkInternalApi;
import cz.o2.proxima.s3.shaded.com.amazonaws.retry.RetryMode;
import cz.o2.proxima.s3.shaded.com.amazonaws.retry.internal.MaxAttemptsResolver;
import cz.o2.proxima.s3.shaded.com.amazonaws.retry.v2.RetryPolicy;
import cz.o2.proxima.s3.shaded.com.amazonaws.retry.v2.RetryPolicyContext;
import cz.o2.proxima.s3.shaded.com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public class RetryPolicyAdapter
implements RetryPolicy {
    private final cz.o2.proxima.s3.shaded.com.amazonaws.retry.RetryPolicy legacyRetryPolicy;
    private final ClientConfiguration clientConfiguration;
    private final int maxErrorRetry;

    public RetryPolicyAdapter(cz.o2.proxima.s3.shaded.com.amazonaws.retry.RetryPolicy legacyRetryPolicy, ClientConfiguration clientConfiguration) {
        this.legacyRetryPolicy = ValidationUtils.assertNotNull(legacyRetryPolicy, "legacyRetryPolicy");
        this.clientConfiguration = ValidationUtils.assertNotNull(clientConfiguration, "clientConfiguration");
        this.maxErrorRetry = this.resolveMaxErrorRetry();
    }

    @Override
    public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getBackoffStrategy().delayBeforeNextRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return !this.maxRetriesExceeded(context) && this.isRetryable(context);
    }

    public boolean isRetryable(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getRetryCondition().shouldRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    public cz.o2.proxima.s3.shaded.com.amazonaws.retry.RetryPolicy getLegacyRetryPolicy() {
        return this.legacyRetryPolicy;
    }

    private int resolveMaxErrorRetry() {
        if (this.legacyRetryPolicy.isMaxErrorRetryInClientConfigHonored() && this.clientConfiguration.getMaxErrorRetry() >= 0) {
            return this.clientConfiguration.getMaxErrorRetry();
        }
        Integer resolvedMaxAttempts = new MaxAttemptsResolver().maxAttempts();
        if (resolvedMaxAttempts != null) {
            return resolvedMaxAttempts - 1;
        }
        if (this.shouldUseStandardModeDefaultMaxRetry()) {
            return 2;
        }
        return this.legacyRetryPolicy.getMaxErrorRetry();
    }

    private boolean shouldUseStandardModeDefaultMaxRetry() {
        RetryMode retryMode = this.clientConfiguration.getRetryMode() == null ? this.legacyRetryPolicy.getRetryMode() : this.clientConfiguration.getRetryMode();
        return retryMode.equals((Object)RetryMode.STANDARD) && this.legacyRetryPolicy.isDefaultMaxErrorRetryInRetryModeHonored();
    }

    public boolean maxRetriesExceeded(RetryPolicyContext context) {
        return context.retriesAttempted() >= this.maxErrorRetry;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }
}

