/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.internal;

import cz.o2.proxima.s3.shaded.com.amazonaws.AmazonClientException;
import cz.o2.proxima.s3.shaded.com.amazonaws.AmazonWebServiceRequest;
import cz.o2.proxima.s3.shaded.com.amazonaws.annotation.SdkTestInternalApi;
import cz.o2.proxima.s3.shaded.com.amazonaws.internal.SdkPredicate;
import cz.o2.proxima.s3.shaded.com.amazonaws.retry.RetryPolicy;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.internal.CompleteMultipartUploadRetryablePredicate;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.model.AmazonS3Exception;
import cz.o2.proxima.s3.shaded.com.amazonaws.util.ValidationUtils;

public class CompleteMultipartUploadRetryCondition
implements RetryPolicy.RetryCondition {
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private final SdkPredicate<AmazonS3Exception> completeMultipartRetryablePredicate;
    private final int maxCompleteMultipartUploadRetries;

    public CompleteMultipartUploadRetryCondition() {
        this(new CompleteMultipartUploadRetryablePredicate(), 3);
    }

    @SdkTestInternalApi
    CompleteMultipartUploadRetryCondition(SdkPredicate<AmazonS3Exception> predicate, int maxRetryAttempts) {
        ValidationUtils.assertNotNull(predicate, "sdk predicate");
        this.completeMultipartRetryablePredicate = predicate;
        this.maxCompleteMultipartUploadRetries = maxRetryAttempts;
    }

    @Override
    public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
        if (exception instanceof AmazonS3Exception) {
            return this.completeMultipartRetryablePredicate.test((AmazonS3Exception)exception) && retriesAttempted < this.maxCompleteMultipartUploadRetries;
        }
        return false;
    }
}

